(function($){

    // стратегия "Показ под результатами поиска"
    BEM.blocks['b-model'].register('b-strategy-no-premium', {

        fields: {
            'place': {type: 'string', 'default': 'highest_place'}
        }

    });

    BEM.DOM.decl({name: 'b-strategy-no-premium', baseBlock: 'b-model-block'}, {
        onSetMod: {
            'js': function(){
                var options = this.elem('options'),
                    _this = this,
                    uniqName = $.identify();

                this.initConsts();
                this.initModel();
                this.bindErrorEvents();

                this.model.on('reset', function(){ _this.updateDomByModel() });

                $.map(['highest-place', 'min-price'], function(el){
                    var radio = _this.elem('radio-' + el).attr('name', uniqName);

                    radio.change(function(){ _this.model.set('place', options.find('input:checked').val()) });
                    _this.elem('radio-' + el + '-label').click(function(){ radio.prop('checked', true).change() })
                });

                this.updateDomByModel();

            }
        },

        getStrategyData: function(){
            var model = this.model,
                place = model.get('place');

            model.stateData = model.memento();

            return {
                strategy: { name: 'no-premium', place: place },
                description: {
                    title: this.params.title,
                    text: place == 'highest_place' ?
                        iget('На наивысшей доступной позиции') :
                        iget('В &laquo;гарантии&raquo; по минимальной цене')
                }
            }
        },

        updateDomByModel: function(){
            this.model.stateData = this.model.memento();
            this.elem('radio-' + this.model.get('place').replace(/_/g, '-')).prop('checked', true);
        }

    }, {
        live: true
    });
})(jQuery);
