(function($) {
    BEM.DOM.decl({name: 'b-strategy-select-easy', modName: 'loading', modVal: 'ajax'}, {
        onSetMod: {
            js: function() {
                this.__base();

                this._getSwitcher().on('click', this._toggle, this);
                this.model
                    .onField('saving_status', 'change', this.onSavingStatusChange, this)

            }
        },

        getPane: function(strategy) {
            strategy = strategy || this.model.get('strategy');
            return this.strategiesPanes[strategy] ||
                (this.strategiesPanes[strategy] = this.getPopup().findBlockInside({blockName: 'b-strategy-select-easy__pane', modName: 'strategy', modVal: strategy.replace(/_/g, '-')}));
        },



        onSavingStatusChange: function() {
            this.setMod('saving-status', this.model.get('saving_status'));

            if (this.model.get('saving_status') == 'ok') {
                if (this.model.get('strategy') == 'easy_week_bundle')
                direct.CampOptions.update({
                    'easy_week_bundle_limit_clicks':  this.strategiesModels['easy_week_bundle'].get('easy_week_bundle_limit_clicks'),
                    //нужно сохранять дробное значение
                    'easy_week_bundle_period': this.strategiesModels['easy_week_bundle'].raw('easy_week_bundle_period'),
                    'easy_week_bundle_sum': this.strategiesModels['easy_week_bundle'].get('easy_week_bundle_sum')
                });

                this.updateNotice();
                this.updateTitle();
            }

        },

        canBeEmpty: function() {
            return true;
        },

        onLoadingStatusChange: function() {
            this.__base();
            var status = this.model.get('loading_status');
            this.setMod('loading-status', status);
            this._getSwitcher().setMod('disabled', status == 'process' ? 'yes' : 'no');
        },



        getPopup: function() {
            if (!this._popup) {
                this._popup =
                    this.findBlockInside(this.params.popupName || 'b-popupa')
                        .on('show', this.onShow, this)
                        .on('hide', this.onHide, this)
                        .on('outside-click', function(e) {
                            e.preventDefault();
                        }, this);


            }
            return this._popup;

        },

        onShow: function() {
        },

        onHide: function() {
            this.model.rollback(this, ['loading_status']);
            var _this = this;

            //откатываем только те вкладки, которые были проинициализированы
            $.each(this.strategiesPanes, function(name, pane) {
                _this.strategiesModels[name].rollback();
            })

        },

        _getSwitcher : function() {
            return this._switcher ||
                (this._switcher =
                    this.findBlockInside('b-' + (this.getMod(this.elem('switcher'), 'type') || 'pseudo-link')));
        },

        _toggle: function() {
            //если уже грузится что-то - продолжаем спокойно грузить, этот запрос игнорим
            if (this.model.get('loading_status') == 'process') { return; }
            
            var popup = this.getPopup();

            //если попап уже показывается - дефолтное сокрытие
            if (popup.isShowed()) {
                popup
                    .hide();
                return this;
            }

            if (this.model.get('forecast')) {
                popup
                    .show(this.elem('switcher'));
                this.strategiesPanes[this.model.get('strategy')].resetPane();

            } else {
                this.loadPopupData();
            }

        },

        //DIRECT-24183: форматирование суммы бюджета
        _formatNumber: function(number) {
            return BEM.blocks['i-formater'].format(number, {
                precision: 0,
                exponent_delimiter: ' '
            });
        },

        updateTitle: function() {
            var strategy = this.model.get('strategy');
            if (strategy == 'distributed') {
                this.elem('current').html(this._formatNumber(this.strategiesModels['distributed'].get('manual_autobudget_sum')))
            }

            if (strategy == 'easy_week_bundle') {
                this.elem('clicks').html(this.strategiesModels['easy_week_bundle'].get('easy_week_bundle_limit_clicks'))
                this.elem('sum').html(common.format.number(this.strategiesModels['easy_week_bundle'].get('easy_week_bundle_sum'), 0, ' '));
            }

            if (strategy == 'fast') {
                var positions_strategy = this.strategiesModels['fast'].get('positions_strategy');
                $.each(['high', 'middle', 'low'], $.proxy(function(i, name) {
                    this.elem(name).toggleClass('g-hidden', name != positions_strategy);
                }, this))
            }

            this.elem('easy-week-bundle').toggleClass('g-hidden',  strategy != 'easy_week_bundle');
            this.elem('distributed').toggleClass('g-hidden',  strategy != 'distributed');
            this.elem('fast').toggleClass('g-hidden', strategy != 'fast');
        },





        loadPopupData: function() {
            this.model.update({'loading_status': 'process'});
            this.model.set('forecast', null);

            var curr = direct.ForecastUtils.getCurrency(),
                pCurr = direct.ForecastUtils.getPseudoCurrency(),

                requestParams = {
                    pseudo_currency_id: curr == 'YND_FIXED' ? pCurr.id : '',
                    convUnitRate: curr == 'YND_FIXED' ? pCurr.rate : 1
                };

            if (this.params.ulogin) {
                requestParams.ulogin = this.params.ulogin
            }
            if (this.params.cid)  {
                requestParams.cid = this.params.cid;
            }

            this.loader.loadCampaignPhrases({
                    success: $.proxy(this.onDataLoaded, this),
                    error: $.proxy(this.onDataLoadedError, this)
                }, requestParams);

        },

        onDataLoaded: function(forecast) {
            this.getPopup().show(this.elem('switcher'));
            this.__base(forecast);
        },

        onDataLoadedError: function() {
            this.getPopup().show(this.elem('switcher'));
            this.__base();
        },

        setForecast: function(forecast) {
            this.__base(forecast);
            this.getPopup().setForecast(forecast);

        },

        updateNotice: function () {
            if (!this.elem('attention')) return;
            this.elem('attention').toggleClass('g-hidden', this.model.get('strategy') != 'distributed' || this.strategiesModels['distributed'].get('manual_autobudget_sum') <= this.model.get('forecast').getMaxBudget())
        }



    });
})(jQuery);




