(function($) {
    BEM.DOM.decl({name: 'b-strategy-select-easy', modName: 'loading', modVal: 'hidden'}, {
        onSetMod: {
            'js': function() {
                this.__base();

                this.elem('WordSuggestions').bind('b-word-suggestions_change', $.proxy(this.onDataChange, this));
                this.elem('Geo').bind('change', $.proxy(this.onDataChange, this));
                this.model.onField('strategy', 'change', this.onStrategyChanged, this);

                this.onDataChange();
            }
        },

        canBeEmpty: function() {
            return !this.model.get('is_first');
        },

        onStrategyChanged: function() {
            this.__base();
            this.elem('strategy').val(this.model.get('strategy'));
        },

        clearPanes: function() {
            var strategy = this.model.get('strategy');
            $.each(this.strategiesPanes, function(name, pane) {
                if (name != strategy) {
                    pane.clearInputs();
                }
            })

        },

        getPane: function(strategy) {
            strategy = strategy || this.model.get('strategy');
            return this.strategiesPanes[strategy] ||
                (this.strategiesPanes[strategy] = this.findBlockInside({blockName: 'b-strategy-select-easy__pane', modName: 'strategy', modVal: strategy.replace(/_/g, '-')}));
        },


        updateHiddens: function() {
            var data = this.strategiesModels[this.model.get('strategy')].memento(false, true, 'toServer'),
                html = [];

            $.each(data, function(name, value) {
                html.push({tag: 'input', attrs: {name: name, value: value, type: 'hidden'}})
            });

            this.elem('hiddens').html(BEM.HTML.build(html));
        },

        onDataChange: function() {

            this.model.update({'loading_status': 'process'});

            this.model.set('forecast', null);

            var curr = direct.ForecastUtils.getCurrency(),
                pCurr = direct.ForecastUtils.getPseudoCurrency(),

                requestParams = {
                    pseudo_currency_id: curr == 'YND_FIXED' ? pCurr.id : '',
                    convUnitRate: curr == 'YND_FIXED' ? pCurr.rate : 1
                };

            if (this.params.ulogin)  {
                requestParams.ulogin = this.params.ulogin;
            }

             if (this.params.cid && !this.model.get('is_first'))  {
                requestParams.cid = this.params.cid;
             }

             if (this.params.bid)  {
                requestParams.bid = this.params.bid;
             }
            this.loader.loadForecast(
                this.elem('WordSuggestions').data('api').getAllPhrases(),
                this.elem('Geo').val(),
                {
                    success: $.proxy(this.onDataLoaded, this),
                    error: $.proxy(this.onDataLoadedError, this)
                },
                requestParams,
                this.model.get('is_first')
            );
        }
    }, {
        live : false
    });
})(jQuery);



