(function($) {
    BEM.blocks['b-model'].register('b-easy-campaign-strategy', {
        fields: {

            //служебные поля - процесс сохранения и процесс загрузки
            'loading_status': {type: 'string', 'default': 'no'},
            'saving_status': {type: 'string'},

            //находимся на странице редактирования
            'is_edit': {type: 'flag'},

            //первое объявление в кампании
            'is_first': {type: 'flag'},

            'strategy': {type: 'string'},
            'forecast': {type: 'const'},

            'forecast_num': {type: 'number', 'default': 0}
        },
        controllersNames: ['forecast']
    });

    BEM.DOM.decl({name: 'b-strategy-select-easy'}, {
        onSetMod: {
            'js': function() {
                this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy');
                var _this = this;
                this.strategiesPanes = {};
                this.strategiesModels = {};

                // здесь генерируются b-easy-campaign-strategy-easy-week-bundle, b-easy-campaign-strategy-fast, b-easy-campaign-strategy-distributed
                $.each(['easy-week-bundle', 'fast', 'distributed'], function(i, name) {
                    _this.strategiesModels[name.replace(/-/g, '_')] =
                        BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy-' + name);
                });

                this.strategiesPanes = {};

                this.model.set('forecast', null);

                this.loader = BEM.blocks['i-easy-forecast__loader'];
                //число загрузок прогноза
                this.loadingCount = 0;
                //попутно инициализируем блоки
                this.tabbedPane = this.findBlockInside('b-tabbed-pane');

                this.model
                    .onField('strategy', 'change', this.onStrategyChange, this)
                    .onField('loading_status', 'change', this.onLoadingStatusChange, this);

                this.tabbedPane.on('current', this.onSwitchStrategyPane, this);
            }
        },

        onLoadingStatusChange: function(e) {
            this.getPane().onLoading(e);
        },

        onStrategyChange: function(e) {
            this.getPane().onLoading(e);
            //todo - действие повторяется два раза - подумать как лучше
            this.tabbedPane.selectByIndex($.inArray(this.model.get('strategy'), ['easy_week_bundle', 'fast', 'distributed']))
        },

        onSwitchStrategyPane: function(e, data) {
            var strategy = this.tabbedPane.getMod(data.current, 'strategy').replace(/-/g, '_');
            this.model.update({'strategy':  strategy}, this)

        },

        setForecast: function(forecast) {
            this.model.set('forecast', forecast)
        },

        onDataLoadedError: function() {
            //запрос отвалился по таймауту или пришел в неправильном формате
            this.model.update({'loading_status': 'error'});

        },

        onDataLoaded: function(forecast) {
            this.loadingCount++;
            this.model.update({'forecast_num': this.loadingCount});

            this.setForecast(forecast);
            //запрос был без ключевых фраз
            if (forecast.isEmpty() && !this.canBeEmpty()) {
                this.model.update({'loading_status': 'empty'});
            } else {
                this.model.update({'loading_status': 'success'});
            }

        },

        canBeEmpty: function() {
            return false;
        }
    }, {
        toServer: {
            'strategy': {
                'easy-week-bundle': 'easy_week_bundle',
                'fast': 'fast',
                'distributed': 'distributed'
            }
        }
    });
})(jQuery);



