(function($) {
    BEM.DOM.decl('b-strategy-select-easy__pane', {
        onSetMod: {
            'js': function() {
                this.strategyModel = BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy-' + this.getMod('strategy'));
                this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy');
            }
        },

        onPaneSwitch: function() {

        },

        onLoading: function(e) {
            var status = this.model.get('loading_status');

            this.setMod(this.elem('content'), 'loading', status);
            //если пошла загрузка нового прогноза, чистим информацию о том, что старый загружен
            if (status == 'process') {
                this.loaded = false;
                this.strategyModel.set('forecast', 'empty');
            }

            if (this[status + 'Loading'] && !this.loaded) {
                this[status + 'Loading'].call(this);
            }
        },

        clearInputs: function() {
            this.domElem.find('input').val('');
        },


        resetPane: function() {
            this._validate();
        },



        processLoading: function() {
            this.delMod(this.elem('content'), 'forecast');
        },

        emptyLoading: function() {
            this.delMod(this.elem('content'), 'forecast');
        },

        errorLoading: function() {
            this.delMod(this.elem('content'), 'forecast');
        },

        successLoading: function() {
             //загруженный прогноз ненадёжен
            if (this.isForecastValid()) {
                this.setMod(this.elem('content'), 'forecast', 'valid');
                this.onValidForecast();
            } else {
                this.setMod(this.elem('content'), 'forecast', 'invalid');
                this.onInvalidForecast();
            }
        },

        skipLoading: function() {
            if (!this.model.get('is_edit') && this.model.get('is_first')) {
                this.onInvalidForecast();
            }
        }

    }, {
        live: true
    })

})(jQuery);


