(function($) {
    var curr,
        currObj,
        pCurr,
        name,
        rate,
        MIN_AUTOBUDGET,

        easyCurrencyDataCalculated = false,
        fillEasyCurrencyData = function() {
            if (easyCurrencyDataCalculated) return;

            curr = direct.ForecastUtils.getCurrency();
            currObj = get_currency(curr);
            pCurr = direct.ForecastUtils.getPseudoCurrency();
            rate = curr == 'YND_FIXED' ? pCurr.rate : 1;

            name = curr == 'YND_FIXED' ? pCurr.name : currObj.name;

            MIN_AUTOBUDGET = get_currency(curr).MIN_AUTOBUDGET * rate;

            easyCurrencyDataCalculated = true;
        };

    BEM.blocks['b-model'].register('b-easy-campaign-strategy-distributed', {
        fields: {
            'manual_autobudget_sum': {type: 'number', precision: 0, toServer: 1},
            //выдаём ли варнинг об изменившемся бюджете
            'check_budget_change': {type: 'flag'},
            //служебное поле - служит для сравнения
            'original_budget': {type: 'number', precision: 0},
            'recomended_budget': {type: 'number', precision: 0},
            'forecast': {type: 'string'},
            'currency': {type: 'string'}

        },

        validateRules: function() {
            fillEasyCurrencyData();

            return {
                'manual_autobudget_sum': {
                    list: [
                        {name: 'required', id: 'required', text:  iget('Введено некорректное значение')},
                        {name: 'format', id: 'format', text:  iget('Введено некорректное значение')},
                        {
                            id: 'min',
                            name: 'min',
                            value: MIN_AUTOBUDGET,
                            text: iget('Минимальный бюджет: %s', MIN_AUTOBUDGET + ' ' + name)
                        },
                        {
                            id: 'changed',
                            name: 'changed',
                            warning: 1,
                            condition: function() {
                                return this.get('check_budget_change');
                            },
                            validator: function(value) {
                                return !this.get('original_budget') || this.get('original_budget') == this.get('manual_autobudget_sum');
                            },
                            text: function() {
                                return iget('Изменен размер недельного бюджета для всех объявлений с %s до %s. Сохранить?',
                                    this.get('original_budget') + ' ' + name,
                                    this.get('manual_autobudget_sum') + ' ' + name
                                )
                            }
                        }
                    ]
                }
            }
        }

    });

    BEM.DOM.decl({name: 'b-strategy-select-easy__pane', modName: 'strategy', modVal: 'distributed'}, {
        onSetMod: {
            'js': function() {

                this.strategyModel =
                    BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy-distributed')
                        .onField('original_budget', 'change', this.onOriginalBudgetChanged, this)
                        .onField('manual_autobudget_sum', 'change', this.onSumChanged, this)
                        .set('forecast', 'no')
                        .on('error-set error-clear', this._onErrors, this);

                fillEasyCurrencyData();

                this.slider = $('.b-strategy-select-easy__pane__slider-container').bem('b-money-meter-slider');

                this.__base.apply(this);

                this.disabled = false;

                this.setDisabled(true);

                this
                    .setMod('min', 'no')
                    .bindTo('TotalBudget', 'blur keypress', this.onTotalBudgetChange);

                this.elem('RecomendedBudget').length > 0 && this.bindTo('RecomendedBudget', 'click', this.onRecomendedBudgetClick);

                this.RecomendedClicksMessage = this.elem('RecomendedClicks').html();

                this.elem('OriginalBudget').length > 0 && this.bindTo('OriginalBudget', 'click', this.onOriginalBudgetClick);

                this.model.onField('saving_status', 'change', this.onSaving, this);

                this.slider.onSlideChange($.proxy(this.onSliderMove, this));

            }
        },

        _onErrors: function() {
            var _this = this;

            $.each(['errors', 'warnings'], function(i, type) {
                _this.elem(type).html(_this.strategyModel.getErrorsMessagesForModel(type).join(''))
            });

            this.elem('forecast-total').toggleClass('g-hidden', this.strategyModel.hasErrors());

        },


        onSaving: function() {

        },

        processLoading: function() {
            this.__base();
            this.setDisabled(true);
            this.strategyModel.clearModelErrors();
        },

        emptyLoading: function() {
            this.__base();
            this.setDisabled(true);
            this.strategyModel.clearModelErrors();
        },



        errorLoading: function() {
            this.__base();
            this.onInvalidForecast();

        },

        isValuesDefault: function() {
            return this.strategyModel.get('manual_autobudget_sum') == MIN_AUTOBUDGET;
        },

        onValidForecast: function() {
            this.strategyModel.set('forecast', 'valid');
            this.updateRecommendedBudget();
            //дергаем вручную
            this.onRecomendedBudgetChanged();
            this.setDisabled(false, true);
            //если мы уже ввели что-то руками или находимся на редкатировании
            //и у нас загрузился первый из прогнозов
            //если  у нас нет пока значения для бюджета на неделю
            if (!this.strategyModel.get('manual_autobudget_sum') ||
                //при этом мы не на редактировании и с дефолтными значениями
                (!this.strategyModel.isChanged('input') && !this.model.get('is_edit') && this.isValuesDefault())) {

                this.strategyModel.update({'manual_autobudget_sum': this.strategyModel.get('recomended_budget')});

            }
            this.updateSliderCounters();
            this.updateSliderPosition();
            this.updateSliderMinBoundary();
            this.updateSliderMarks();
        },

        resetPane: function() {
            this.updateRecommendedBudget();
            this._validate();
        },


        onInvalidForecast: function() {

            this.strategyModel.set('forecast', 'invalid');
            this.setDisabled(true, true);

            this.strategyModel.update({
                'manual_autobudget_sum': this.strategyModel.get('manual_autobudget_sum') || MIN_AUTOBUDGET
            });
            this.strategyModel.validateModel();
        },

        isForecastValid: function() {
            var forecast = this.model.get('forecast');
            if (!forecast) { return false; }
            return forecast.isValid() && forecast.isReliable
        },


        onRecomendedBudgetClick: function() {
            this.strategyModel.update({'manual_autobudget_sum': this.strategyModel.get('recomended_budget')});
        },

        onRecomendedBudgetChanged: function() {
            if (!this.model.get('forecast')) { return; }
            var recomendedBudget = this.strategyModel.view('recomended_budget'), clicks;

            if (this.elem('RecomendedBudget').length > 0) {
                this.elem('RecomendedBudget').html(this.strategyModel.view('recomended_budget'));
                //fix IE bug
                this.elem('RecomendedBudget').css({'display': 'inline'})
            }
            if(this.elem('RecomendedBudget').length > 0 && this.elem('RecomendedClicks').length > 0) {
                clicks = this.model.get('forecast').money2clicks(this.strategyModel.get('recomended_budget'));
                this.elem('RecomendedClicks').html(common.inflector.pluralize(this.RecomendedClicksMessage, common.format.number(clicks, 0, '&nbsp;'), clicks));
            }
        },


        setDisabled: function(disabled, enableTotal) {
            this.disabled = disabled;
            if (disabled) {
                this.setMod('disabled', 'yes');
            } else {
                this.delMod('disabled')
            }

            this.elem('TotalBudget').prop('disabled', enableTotal ? false : this.disabled);
            this.slider.setDisabled(this.disabled);

        },


        onTotalBudgetChange: function(e) {
            if (e.type != 'blur' && !(e.type == 'keypress' && e.which == 13)) { return true; }
            if (e.type == 'keypress' && e.which == 13) { e.preventDefault();  }
            this.strategyModel.update({ 'manual_autobudget_sum': this.elem('TotalBudget').val()});

        },

        onSumChanged: function(e, data) {
            var sum = this.strategyModel.get('manual_autobudget_sum');
            this.elem('TotalBudget').val(sum);
            this.updateOriginalBudgetContainer();

            var isValid = this.strategyModel.validate();
            if (this.disabled) return;
            if (!data || data.source != this.slider) {
                this.updateSliderPosition();
            }
            this.updateSliderCounters()
        },

        updateOriginalBudgetContainer: function() {
            if (this.elem('OriginalBudgetContainer').length < 1) return;
            this.elem('OriginalBudgetContainer').toggleClass('g-hidden', !this.strategyModel.get('original_budget') || this.strategyModel.get('original_budget') == this.strategyModel.get('manual_autobudget_sum'));

        },

        onOriginalBudgetChanged: function() {
            if (this.elem('OriginalBudgetContainer').length < 1) return;
            this.elem('OriginalBudget').html(this.strategyModel.get('original_budget'));
            this.updateOriginalBudgetContainer();
        },

        updateSliderPosition: function() {
            if (!this.model.get('forecast')) { return; }
            var value = this.strategyModel.get('manual_autobudget_sum'),
                mark = direct.ForecastUtils.calcSliderMark(this.model.get('forecast'), "sum", value);
            this.updatingSlider = true;
            this.slider.setValue(mark.pos);
            this.updatingSlider = false;

        },

         /**
         * Обновить рекомендованный бюджет и связанный с ним прогноз
         */
        updateRecommendedBudget: function() {
            if (!this.model.get('forecast')) { return; }
            var recomendedBudget = this.model.get('forecast').getRecomendedBudget();
            this.strategyModel.update({'recomended_budget': recomendedBudget});

        },

        updateSliderCounters: function() {
             var budget = this.strategyModel.get('manual_autobudget_sum'),
                totalClicks, phrasesCount, bannerClicks,
                forecast = this.model.get('forecast');
            if (this.elem('TotalClicks').length > 0) {
                totalClicks = forecast.money2clicks(budget);
                this.elem('TotalClicks').html(common.format.number(totalClicks, 0, '&nbsp;'));
            }
            if (this.elem('PhrasesCnt').length > 0) {
                phrasesCount = forecast.money2phrases(budget);
                this.elem('PhrasesCnt').html(common.format.number(phrasesCount, 0, '&nbsp;'));
            }
            if (this.elem('BannerClicks').length > 0) {
                bannerClicks = this.model.get('is_first') ? totalClicks : forecast.money2clicks(budget, {ignore_rest_camp: 1});
                this.elem('BannerClicks').html(common.format.number(bannerClicks, 0, '&nbsp;'));
            }
        },

        onOriginalBudgetClick: function() {
            this.strategyModel.update({'manual_autobudget_sum': this.strategyModel.get('original_budget')});
        },


        updateSliderMinBoundary: function() {
            var leftMarkIsMinimum = direct.ForecastUtils.calcSliderMark(this.model.get('forecast'), "pos", 0).sum == direct.ForecastUtils.MIN_BUDGET;
            this.slider.setMod('min', leftMarkIsMinimum ? 'yes' : 'no')
        },

        updateSliderMarks: function() {
            var length = this.slider.getMarksCount(),
                clickData = [],
                budgetData = [];
            for (var i=0, l = length; i < l; i++) {
                var mark = direct.ForecastUtils.calcSliderMark(this.model.get('forecast'), "pos", direct.ForecastUtils.SLIDER_WIDTH/(l-1)*i);
                clickData.push(common.number.format(mark.clicks, {precision: 0, exponent_delimiter: '<small>&nbsp;</small>'}));
                budgetData.push(common.number.format(mark.sum, {precision: 0, exponent_delimiter: '<small>&nbsp;</small>'}));
            }
            this.slider.updateBudgetMarks(budgetData);
            this.slider.updateClickMarks(clickData);
        },

        onSliderMove: function(e, ui) {
            if (this.disabled || this.updatingSlider) return;
            var mark = direct.ForecastUtils.calcSliderMark(this.model.get('forecast'), "pos", ui.value);
            this.strategyModel.update({'manual_autobudget_sum': mark.sum}, this.slider);
            return true;
        }
    });
})(jQuery);


