(function($) {
    var curr,
        currObj,
        pCurr,
        rate,

        MIN_CLICKS,
        MIN_CPC,
        DEFAULT_SUM,
        MAX_NUM = 1e20,
        PERIOD_DIFF_CONST = 2,

        easyCurrencyDataCalculated = false,

        fillEasyCurrencyData = function() {
            if (easyCurrencyDataCalculated) return;

            curr = direct.ForecastUtils.getCurrency();
            currObj = get_currency(curr);
            pCurr = direct.ForecastUtils.getPseudoCurrency();
            rate = curr == 'YND_FIXED' ? pCurr.rate : 1;

            name = curr == 'YND_FIXED' ? pCurr.name : currObj.name;

            MIN_CLICKS = currObj.MIN_AUTOBUDGET_CLICKS_BUNDLE;
            MIN_CPC = currObj.MIN_AUTOBUDGET_AVG_PRICE;
            DEFAULT_SUM = currObj.MIN_AUTOBUDGET;

            easyCurrencyDataCalculated = true;
        };

    BEM.blocks['b-model'].register('b-easy-campaign-strategy-easy-week-bundle', {
        fields: {
            //состояние прогноза для потока посетителей
            'forecast': {type: 'string'},


            //cpc для хранения на сервере
            'autobudget_avg_bid': {
                type: 'number',
                precision: 2,
                toServer: 1,
                calcValue: function() {
                    fillEasyCurrencyData();

                    var cpcMax = currObj.MAX_AUTOBUDGET_BID * rate,
                        sum = this.raw('easy_week_bundle_sum'),
                        clicks = this.raw('easy_week_bundle_limit_clicks'),
                        cpc = sum / clicks;

                    return Math.min(cpcMax, cpc) / rate;
                }
            },

            //клики, точное значение - тоже храним на сервере
            'easy_week_bundle_limit_clicks': {
                type: 'number', precision: 0, max: MAX_NUM,
                toServer: 1,
                'default': 100,
                input: 1,
                fromServer: 1,
                children: ['autobudget_avg_bid', 'easy_week_bundle_sum_hidden']
            },

            'easy_week_bundle_sum': {
                type: 'number', precision: 0, max: MAX_NUM, fromServer: 1,
                toServer: 1,
                input: 1,
                children: ['autobudget_avg_bid', 'easy_week_bundle_sum_hidden']
            },

            //сумма для сохранения на сервер, с учетом ограничений и прочей фигни
            'easy_week_bundle_sum_hidden': {
                type: 'number', precision: 0,
                toServer: 1,
                calcValue: function() {
                    var cpcMax = this.raw('easy_week_bundle_cpc_max'),
                        sum = this.raw('easy_week_bundle_sum'),
                        clicks = this.raw('easy_week_bundle_limit_clicks');

                    if (!sum || !clicks) { return 0 }

                    var sumMax = Math.round(cpcMax * clicks * 1.2);

                    return sum > sumMax && sumMax != 0 ? sumMax : sum
                }
            },

            //клики в пересчёте в неделю - для серверных операций
            'autobudget_limit_clicks': function() {
                fillEasyCurrencyData();

                return {
                    type: 'number',
                    value: MIN_CLICKS,
                    precision: 0,
                    toServer: 1,
                    calcValue: function() {
                        var clicks = this.raw('easy_week_bundle_limit_clicks'),
                            period = this.raw('easy_week_bundle_period');
                        if (!clicks || !period) return 0;

                        return  7 * clicks / period;
                    }
                }
            },


            //не сохраняется на сервере, вычисляется из autobudget_sum и easy_week_bundle_limit_clicks
            'easy_week_bundle_period': {
                type: 'number', precision: 0, value: 7, fromServer: 1,
                children: ['autobudget_limit_clicks']
            },

            'min_sum_per_clicks': { type: 'number', precision: 0 },
            'min_clicks_per_sum': { type: 'number', precision: 0 },

            'easy_week_bundle_sum_min': { type: 'number', precision: 0 },
            'easy_week_bundle_sum_max': { type: 'number', precision: 0 },
            'easy_week_bundle_cpc_max': { type: 'number', precision: 0, children: ['easy_week_bundle_sum_hidden'] },
            'easy_week_bundle_cpc_min': { type: 'number', precision: 0 },

            //минимально возможное число кликов в день
            'autobudget_limit_clicks_min': { type: 'number', precision: 0},
            //максимально возможное число кликов в день
            'autobudget_limit_clicks_max': { type: 'number', precision: 0},
            'currency': {type: 'string'}

        },

        validateRules: function() {
            fillEasyCurrencyData();




            return {
                'easy_week_bundle_limit_clicks': {
                    condition: function() {
                        return this.get('forecast') == 'valid';
                    },
                    list: [
                        {name: 'required', id: 'required',
                            text: iget('Число посетителей должно быть не меньше %s',
                                getMessage(MIN_CLICKS, {'easy_week_bundle_limit_clicks': MIN_CLICKS}))
                        },
                        {name: 'format', id: 'format',
                            text: iget('Введено некорректное значение')
                        },
                        {
                            id: 'min',
                            value: MIN_CLICKS,
                            name: 'min',
                            text: iget('Число посетителей должно быть не меньше %s',
                                getMessage(MIN_CLICKS, {'easy_week_bundle_limit_clicks': MIN_CLICKS}))
                        },
                        function() {
                            var maxPerYear = Math.floor(this.raw('autobudget_limit_clicks_max') * 365);

                            return {
                                id: 'max',
                                name: 'max',
                                condition: function() {
                                    var loadingStatus = BEM.MODEL.get('campaign', 'b-easy-campaign-strategy').get('loading_status');

                                    return loadingStatus != 'empty' && loadingStatus != 'error'
                                },
                                value: maxPerYear,
                                text: iget('Максимальное число посетителей по заданным ключевым фразам – %s за год',
                                    getMessage(maxPerYear, {'easy_week_bundle_limit_clicks': maxPerYear}))
                            }
                        },
                        function() {
                            var minClicksCurrent = this.get('forecast') == 'valid' ?
                                Math.min(MIN_CLICKS, this.get('autobudget_limit_clicks_min')) :
                                MIN_CLICKS;
                            //Число кликов за полный день
                            return {
                                warning: 1,
                                id: 'day-clicks',
                                name: 'min',

                                value: minClicksCurrent,
                                text: iget('Прогнозируемое число посетителей за полный день: %s',
                                    getMessage(minClicksCurrent, {'easy_week_bundle_limit_clicks': minClicksCurrent }, 1))

                            }
                        },
                        function() {
                            //максимальное число кликов, которое можно привлечь за год
                            var maxPerYear = this.raw('autobudget_limit_clicks_max') * 365,
                                 //число кликов рассчитанное по введённой сумме и максимально возможному cpc
                                maxByCpc = Math.round(Math.min(this.raw('easy_week_bundle_sum') / this.raw('easy_week_bundle_cpc_max'),
                                                       maxPerYear));

                            //бюджет позволит привлечь больше посетителей
                            return {
                                warning: 1,
                                id: 'more-clicks',
                                name: 'min',
                                value: maxByCpc,
                                condition: function() {
                                    if (this.get('forecast') == 'valid' && !isNaN(this.get('easy_week_bundle_sum'))) {
                                        return maxByCpc > MIN_CLICKS;
                                    } else {
                                        return false;
                                    }
                                },
                                text: iget('Бюджет позволит привлечь %s посетителей.',
                                    getMessage(maxByCpc, {'easy_week_bundle_limit_clicks': maxByCpc}, 1)
                                )
                            }
                        }
                    ]
                },

                'easy_week_bundle_sum': {
                    condition: function() {
                        var errors = this.getErrors();
                        return (!errors || !errors['easy_week_bundle_limit_clicks'])  && this.get('forecast') != 'empty'
                    },
                    list: [
                        {name: 'required', id: 'required', text: iget('Введите корректное значение')},
                        {name: 'format', id: 'format', text: iget('Введите корректное значение')},
                        {
                            name: 'max',
                            condition: function() {
                                //показываем только если нет других прежупреждений   и есть валидный прогноз
                                return !this.getWarnings() && this.get('forecast') == 'valid';
                            },
                            id: 'max',
                            type: 'warning',
                            value: function() {
                                return this.get('easy_week_bundle_sum_hidden');
                            },
                            text: iget(' Максимальный бюджет для заданного числа посетителей - %s %s',
                                getMessage(this.get('easy_week_bundle_sum_hidden'), {'easy_week_bundle_sum': this.get('easy_week_bundle_sum_hidden')}), name, 1)

                        },
                        //Недостаточный бюджет для привлечения заданного числа посетителей в максимально прогнозируемый срок
                        function() {
                            var minClicks = this.raw('autobudget_limit_clicks_min'),
                                maxPeriodPerClicks = minClicks == 0 ? 365 : Math.min(365, this.raw('easy_week_bundle_limit_clicks')/minClicks),
                                sumPerMaxPeriod = BEM.MODEL.get('campaign', 'b-easy-campaign-strategy').get('forecast').getSumForPeriod(this.raw('easy_week_bundle_limit_clicks'), maxPeriodPerClicks);
                            return {
                                name: 'min',
                                id: 'min',
                                value: function() {
                                    return this.get('forecast') == 'valid' ? Math.floor(sumPerMaxPeriod) : rate * MIN_CLICKS * MIN_CPC
                                },
                                text: function() {
                                    if (this.get('forecast') != 'valid') {
                                        var minValue = rate * MIN_CLICKS * MIN_CPC;

                                        return iget('Минимальный бюджет для привлечения заданного числа посетителей - %s',
                                            getMessage(minValue + ' ' + name, { 'easy_week_bundle_sum': minValue }))
                                    }

                                    var minSum = this.raw('easy_week_bundle_sum_min'),
                                        currentSum = this.raw('easy_week_bundle_sum'),
                                        maxPeriodPerSum = minSum == 0 ? 365 : Math.min(365, currentSum/minSum),
                                        clicksPerMaxPeriodPerSum = Math.round(BEM.MODEL.get('campaign', 'b-easy-campaign-strategy').get('forecast').getClicksForSum(currentSum, maxPeriodPerSum));

                                    //DIRECT-15164
                                    if (currentSum == sumPerMaxPeriod || Math.abs(currentSum - sumPerMaxPeriod) < 0.2 * currentSum) {
                                        sumPerMaxPeriod = sumPerMaxPeriod + 0.2 * currentSum;
                                    }

                                    var clickParams = maxPeriodPerClicks < 365 ? { 'easy_week_bundle_sum': sumPerMaxPeriod } : { 'easy_week_bundle_sum': sumPerMaxPeriod, 'easy_week_bundle_period': 365 };
                                    var messageEnd = getMessage(Math.round(sumPerMaxPeriod) + ' ' + name, clickParams);
                                    var message = maxPeriodPerClicks < 365 ?
                                        iget('Минимальный бюджет для привлечения заданного числа посетителей - %s', messageEnd) :
                                        iget('Бюджет для привлечения заданного числа посетителей за год - %s', messageEnd);

                                    if (currentSum/clicksPerMaxPeriodPerSum >= MIN_CPC * rate && clicksPerMaxPeriodPerSum >= MIN_CLICKS && clicksPerMaxPeriodPerSum <= this.raw('autobudget_limit_clicks_max') && clicksPerMaxPeriodPerSum != this.get('easy_week_bundle_limit_clicks')) {
                                        var clicksMsg = Math.round(clicksPerMaxPeriodPerSum) + ' ' + common.inflector.pluralizeWord([iget('посетитель'), iget('посетителя'), iget('посетителей')], clicksPerMaxPeriodPerSum);

                                        message += ' ' + iget('Или %s за %s %s', getMessage(clicksMsg, {'easy_week_bundle_limit_clicks': clicksPerMaxPeriodPerSum}), this.get('easy_week_bundle_sum'), name);
                                    }

                                    return message;
                                }
                            }
                        }

                    ]
                }
            }
        }

    });


    function getMessage(content, onClickParams, isWarning) {
        return BEM.HTML.build({
            block : 'b-pseudo-link',
            mods: {'const': 'yes', 'is-bem': 'yes'},
            js: {data: onClickParams},
            cls: isWarning ? '' : 'g-common__red',
            content : content
        })
    }



    BEM.DOM.decl({name: 'b-strategy-select-easy__pane', modName: 'strategy', modVal: 'easy-week-bundle'}, {
        onSetMod: {
            'js': function() {
                fillEasyCurrencyData();

                this.__base.apply(this);
                this.setDisabled(true);
                var _this = this;
                _this.periodDropdown = _this.findBlockInside('b-dropdowna');
                _this.periods = this.periodDropdown.getPopup().findBlocksInside('b-pseudo-link');

                $.each(this.periods, $.proxy(function(i, period){
                    period.on('click', $.proxy(this._onPeriodSelect, this));
                }, this));
                this.disabled = false;

                $.each(['easy_week_bundle_limit_clicks', 'easy_week_bundle_sum'], function(i, field) {
                    _this.bindTo(_this.strategyModel.getElemName(field), 'keydown blur', direct.utils.decorator(_this._onFieldInput, field));
                    _this.strategyModel.onField(field, 'change', {field: field}, _this._onFieldChanged, _this);
                });

                this.strategyModel.onField('easy_week_bundle_period', 'change' , {field: 'easy_week_bundle_period'}, this._onFieldChanged, this);

                this.strategyModel
                    .on('error-set error-clear', this._onErrors, this);
            }
        },

        _isBlurOrEnter: function(e) {
            return (e.type == 'keydown' && e.which == 13 || e.type == 'blur')
        },




        _validate: function() {
            if (!this.model.get('forecast')) { return true; }

            this.strategyModel.clearModelErrors();
            return this.strategyModel.validateModel();

        },

        _onConstApply: function(e) {
            var data = e.block.params.data;


            this.strategyModel.update(data);
            !data['easy_week_bundle_sum'] && this._adjustSum();

            if (this.strategyModel.get('forecast') == 'valid') {
                this._updatePeriod();
            } else {
                this._validate()
            }
        },



        _adjustSum: function() {
            var clicks = this.strategyModel.raw('easy_week_bundle_limit_clicks'),
                minClicks = this.strategyModel.raw('autobudget_limit_clicks_min'),
                maxPeriod = minClicks == 0 ? 365 : Math.min(365, (clicks/minClicks)),
                minSumPerMaxPeriod = this.getSumForPeriod(clicks, maxPeriod);

            if (this.strategyModel.raw('easy_week_bundle_sum') < minSumPerMaxPeriod) {
                this.strategyModel.update({'easy_week_bundle_sum': minSumPerMaxPeriod});
            }
        },

        _updateSumDisabling: function() {
            this.elem('easy-week-bundle-sum').prop('disabled',
                this.getMod('disabled') == 'yes' || this.strategyModel.hasErrors('easy_week_bundle_limit_clicks') ? true : false);
        },

        _onErrors: function() {
            var _this = this;

            $.each(['errors', 'warnings'], function(i, type) {
                $.each(['clicks', 'period', 'sum'], function(j, field) {
                    var text = _this.strategyModel.getErrorsMessagesForField('easy_week_bundle_' + (field == 'clicks' ? 'limit_clicks' : field), type).join('');

                    _this.elem(field + '-' + type).html(text);
                    _this.setMod( _this.elem(field + '-' + type), 'visible', text ? 'yes' : 'no')

                    if (text) {
                        var linkElems = _this.findBlocksInside(_this.findElem(field + '-' + type), 'b-pseudo-link');

                        linkElems.length && $.each(linkElems, function(i, el) {
                            el.on('click', _this._onConstApply, _this)
                        });
                    }
                });

            });

            if (this.model.get('loading_status') == 'process') { return; }

            this.elem('forecast-valid').toggleClass('g-hidden', this.strategyModel.hasErrors());


            this._updatePeriodDisabling();
            if (this.strategyModel.get('forecast') != 'invalid') {
                this._updateSumDisabling();
            }

        },

        /*
         * В поле ввели какие-то данные
         */
        _onFieldInput: function(e, fieldName) {
            if (!this._isBlurOrEnter(e)) { return };
            this.elem('new-forecast-data').addClass('g-hidden');
            this.elem('new-forecast').addClass('g-hidden');
            var data = {};
            data[fieldName] = e.data.domElem.val();
            data.is_edited = 1;
            this.strategyModel.update(data);
            if (this.strategyModel.get('forecast') == 'valid') {
                this._updatePeriod();
            } else {
                this._validate();
            }
        },



        /*
         * Изменилось значение модели
         */
        _onFieldChanged: function(e) {
            var fieldName = e.data.field;

            if (fieldName == 'easy_week_bundle_period') {
                var current = this.strategyModel.get('easy_week_bundle_period'), currentText;

                currentText = current ? '<span class="g-common__bold">' + current + '</span> ' + common.inflector.pluralizeWord([iget("день"), iget("дня"), iget("дней")], current) : iget('Меньше дня');
                this.elem('period-current').html(currentText);
                this.elem('period-hidden').val(this.strategyModel.raw('easy_week_bundle_period'));
            } else {
                this.elem(this.strategyModel.getElemName(fieldName)).val(this.strategyModel.get(fieldName));
            }
        },




        _setPeriodMode: function(periodMode) {
            this.setMod(this.elem('content'), 'period', periodMode);
        },

        _updatePeriodDisabling: function() {
            if (this.strategyModel.hasErrors('easy_week_bundle_limit_clicks') || this.strategyModel.hasErrors('easy_week_bundle_sum')) {
                this._setPeriodMode('disabled');
                return;
            }

            if (this.strategyModel.get('forecast') == 'invalid') {
                this._setPeriodMode('no');
                return;
            }

            var minClicks = this.strategyModel.raw('autobudget_limit_clicks_min'),
                minPeriod = Math.round(Math.min(365, this.strategyModel.raw('easy_week_bundle_limit_clicks')/this.strategyModel.raw('autobudget_limit_clicks_max'))),
                maxPeriod = minClicks == 0 ? 365 : Math.min(365, Math.round(this.strategyModel.raw('easy_week_bundle_limit_clicks')/minClicks)),
                period = this.strategyModel.raw('easy_week_bundle_period'),
                periodRounded = this.strategyModel.get('easy_week_bundle_period'),
                periodType = (periodRounded > 365) ? 'disabled' : maxPeriod - minPeriod <= PERIOD_DIFF_CONST  ? 'short' : 'normal';
            if (periodType == 'short') {
                var value = period < 1 ?
                    iget('Меньше дня') : periodRounded + ' ' + common.inflector.pluralizeWord([iget("день"), iget("дня"), iget("дней")], periodRounded) ;
                this.elem('period-short').html(value);
            }

            //период больше года - показываем ошибку
            this._setPeriodMode(periodType);

            if (periodType != 'normal') { return; }
            $.each(this.periods, $.proxy(function(i, period){
                if (i == 0) {
                    //minPeriod может быть равным нулю
                    var periodFirst = Math.round(minPeriod) || 1;
                    period.domElem.parent('li').toggleClass('g-hidden', periodFirst >= 7)
                    period.domElem.html(periodFirst + ' ' + common.inflector.pluralizeWord([iget("день"), iget("дня"), iget("дней")], periodFirst))
                    period.delMod('period');
                    period.setMod('period', periodFirst)
                }
                var value = period.getMod('period') * 1;
                if (value < minPeriod || value > maxPeriod) {
                    period.setMod('disabled', 'yes')
                } else {
                    period.delMod('disabled')
                }
            }, this));
        },

        _onPeriodSelect: function(e) {
            this.strategyModel.update({'easy_week_bundle_period': e.block.getMod('period'), is_edited: 1});
            this.periodDropdown.getPopup().toggle();
            this.elem('new-forecast-data').addClass('g-hidden');
            this._updateSum();
            this._validate();
        },




        processLoading: function() {
            this.__base();
            this.strategyModel.clearModelErrors();
            this.setDisabled(true);
            this.delMod(this.elem('content'), 'period');
        },

        errorLoading: function() {
            this.__base();
            this.onInvalidForecast();
        },

        emptyLoading: function() {
            this.__base();
            this.strategyModel.clearModelErrors();
            this.delMod(this.elem('content'), 'period');
            this.setDisabled(true);
            this.strategyModel.set('forecast', 'empty');
        },


        /*
         * При создании нового баннера подставляем дефолтные значения
         */
        setDefaults: function() {
            var period = 7,
                minClicksDefault = this.strategyModel.getDefault('easy_week_bundle_limit_clicks'),
                minClicks = this.strategyModel.raw('autobudget_limit_clicks_min'),
            //минимальный период, за который сможем привлечь 100 кликов
                minPeriod = minClicksDefault/(this.strategyModel.raw('autobudget_limit_clicks_max')),
                clicks = minClicks == 0 ? minClicksDefault : Math.max(minClicksDefault, minClicks * 7);

            period = (minPeriod > 7) ? minPeriod : period;
            this.strategyModel.update({
                'easy_week_bundle_limit_clicks': clicks,
                'easy_week_bundle_period': period,
                'easy_week_bundle_sum': this.getSumForPeriod(clicks, period)
            });
            //не делаем сразу initData, чтобы успело выстрелить change
            this.strategyModel.fixData();
            this._validate();
        },

        //данные в новом прогнозе изменились более чем на 20%
        hasSizeableModifications: function() {
            var oldPeriod = this.strategyModel.raw('easy_week_bundle_period'),
                newPeriod = this.getPeriodForSum(this.strategyModel.get('easy_week_bundle_limit_clicks'), this.strategyModel.raw('easy_week_bundle_sum'));
            newPeriod = newPeriod > 365 ? 365 : newPeriod;
            //проверяем изменился ли бюджет
            var diff = Math.abs(oldPeriod - newPeriod),
                maxClicksPerYear = Math.round(this.strategyModel.raw('autobudget_limit_clicks_max') * 365);

            //DIRECT-14927
            return diff/oldPeriod > 0.2  || this.strategyModel.get('easy_week_bundle_limit_clicks')/maxClicksPerYear > 1.2;
        },

        onValidForecast: function() {

            this.strategyModel.set('forecast', 'valid');
            this.delMod(this.elem('content'), 'period');
            this.setDisabled(false);
            if (this.model.get('forecast')) {
                //если есть локальные модификации - пересчитываем срок
                if (this.strategyModel.isChanged('toServer')) {
                    this._updatePeriod();
                    this.adjustTooltips(false);
                } else {
                    this.setDataOnLoad();
                }
            }


            this._validate();

        },

        setDataOnLoad: function() {
            var hasModifications = false,
            //для редактирования все сохраненные данные не считаем дефолтными
                isValuesDefault = this.isValuesDefault();

            //находимся на редактировании кампании и до этого была сохранена другая стратегия
            if (!isValuesDefault) {
                hasModifications = this.hasSizeableModifications();
                if (hasModifications || this.model.get('forecast_num') != 1) {
                    this._updatePeriod();
                }
            } else {
                this.setDefaults();
            }
            this.adjustTooltips(hasModifications, isValuesDefault);
        },

        isValuesDefault: function() {
            return  (!this.model.get('is_edit') || this.model.getFieldStartValue('strategy') != 'easy_week_bundle')
                && !this.model.isChanged('input');
        },

        adjustTooltips: function(hasSizeableModifications, isValuesDefault) {
            var isValid = this.strategyModel.get('forecast') == 'valid';
            this.elem('new-forecast-data').toggleClass('g-hidden', !isValid || this.model.get('forecast_num') <= 1);
            //показываем при первой загрузке прогноза, при условии что прогноз сильно изменился  и значения не дефолтные
            this.elem('new-forecast').toggleClass('g-hidden', !isValid || !hasSizeableModifications || isValuesDefault || !this.model.get('is_edit') && this.model.get('forecast_num') > 1);

        },

        resetPane: function() {
            this._updateLimitValues();
            this.setDataOnLoad();
            this.__base();
        },

        onInvalidForecast: function() {
            fillEasyCurrencyData();

            this.strategyModel.clearModelErrors();
            this.strategyModel.set('forecast', 'invalid');
            this.delMod(this.elem('content'), 'period');
            this.setMod(this.elem('content'), 'period', 'no');
            this.elem('easy-week-bundle-limit-clicks').prop('disabled', true);
            this.elem('easy-week-bundle-sum').prop('disabled', false);
            var data = {
                'easy_week_bundle_limit_clicks': MIN_CLICKS,
                'easy_week_bundle_period': 7
            };
            if (!this.strategyModel.get('easy_week_bundle_sum')) {
                data.easy_week_bundle_sum =  DEFAULT_SUM * rate ;
            }

            this.strategyModel.update(data);
            this._validate();
        },





        _updateLimitValues: function() {
            fillEasyCurrencyData();

            var limits = this.model.get('forecast').getWeekBundleLimitValues();
            this.strategyModel.update({
                 'easy_week_bundle_cpc_min': limits.min.cpc * rate,
                 'easy_week_bundle_sum_min': limits.min.sum * rate / 7,
                 'easy_week_bundle_sum_max': limits.max.sum * rate / 7,
                 'easy_week_bundle_cpc_max': limits.max.cpc * rate,
                 'autobudget_limit_clicks_max': limits.max.clicks / 7,
                 'autobudget_limit_clicks_min': limits.min.clicks/ 7
             });

        },

        isForecastValid: function() {
            fillEasyCurrencyData();

            if (!this.model.get('forecast') ||
                !this.model.get('forecast').dataDistributed ||
                this.model.get('forecast').dataDistributed.length == 0) {
                return false;
            }
            this._updateLimitValues();
            return (this.strategyModel.raw('autobudget_limit_clicks_max') * 365 >= MIN_CLICKS)
        },


        getPeriodForSum: function(clicks, sum) {
            fillEasyCurrencyData();

            var cpcValue = common.number.round(sum / clicks, {precision: 2});
            if (cpcValue < MIN_CPC * rate) {
                return 9999;
            } else {
                var period = this.model.get('forecast').getPeriodForSum(clicks, sum),
                    minClicks = this.strategyModel.raw('autobudget_limit_clicks_min'),
                    maxPeriodPerClicks = minClicks == 0 ? 365 : Math.min(365, this.strategyModel.raw('easy_week_bundle_limit_clicks')/minClicks);
                return period - maxPeriodPerClicks > PERIOD_DIFF_CONST  ? 9999 : period;
            }
        },

        getSumForPeriod: function(clicks, period) {
            return this.model.get('forecast').getSumForPeriod(clicks, period);
        },



        setDisabled: function(disabled) {
            if (disabled) {
                this.elem('new-forecast-data').addClass('g-hidden');
                this.elem('new-forecast').addClass('g-hidden');
                this.setMod('disabled', 'yes');
            } else {
                this.delMod('disabled');
            }
            this.elem('easy-week-bundle-limit-clicks').prop('disabled', disabled);
            this.elem('easy-week-bundle-sum').prop('disabled', disabled);

        },

        _updatePeriod: function(period) {
            if (!this._validate()) { return; }

            var sum = this.strategyModel.raw('easy_week_bundle_sum'),
                clicks = this.strategyModel.raw('easy_week_bundle_limit_clicks');

            if (!!sum && this.model.get('forecast')) {
                if (!period) {
                    period = this.getPeriodForSum(clicks, sum);
                }
                this.strategyModel.update({easy_week_bundle_period: period});
            }
            this._validate();
        },

        _updateSum: function() {
            var period = this.strategyModel.raw('easy_week_bundle_period'),
                clicks = this.strategyModel.raw('easy_week_bundle_limit_clicks');

            if (!!period &&this.model.get('forecast')) {
                this.strategyModel.update({ 'easy_week_bundle_sum': this.getSumForPeriod(clicks, period) })
            }

        }

    });
})(jQuery);


