(function($) {
    BEM.blocks['b-model'].register('b-easy-campaign-strategy-fast', {
        fields: {
            'forecast': {type: 'string', 'default': 0},
            'autobudget_sum': {type: 'number', toServer: 1},
            'positions_strategy': {type: 'string', toServer: 1}
        }
    });

    BEM.DOM.decl({name: 'b-strategy-select-easy__pane', modName: 'strategy', modVal: 'fast'}, {
        onSetMod: {
            'js': function() {
                this.__base.apply(this);
                this.radio = {};
                this.bindTo('PositionStrategy', 'click', this.onPositionStrategyClick);
                this.strategyModel.onField('positions_strategy', 'change', this.onPositionChanged, this);
            }
        },

        processLoading: function() {
            this.__base();
            this.setDisabled(true);
            this.elem('StrategyClick').html('&nbsp;');
        },

        emptyLoading: function() {
            this.__base();
            this.strategyModel.clearModelErrors();
            this.setDisabled(true);
            this.elem('StrategyClick').html('&nbsp;');
        },



        errorLoading: function() {
            this.__base();
            this.onInvalidForecast();
        },

        onValidForecast: function() {
            this.strategyModel.set('forecast', 'valid');
            var forecast = this.model.get('forecast');
            var budgets = [forecast.getBudgetForStrategy('high'), forecast.getBudgetForStrategy('middle'), forecast.getBudgetForStrategy('low')];
            for (var i = 0, clicks = 0; i < budgets.length; i++) {
                clicks = roundClicks(this.model.get('forecast').money2clicks(budgets[i]));

                $(this.elem('StrategyClick').get(i)).html(common.number.format(clicks, {precision: 0, exponent_delimiter: '&nbsp;'}));
                if (this.elem('StrategyCost').length > 0) {
                    $(this.elem('StrategyCost').get(i)).html(common.number.format(budgets[i], {precision: 0, exponent_delimiter: '&nbsp;'}))
                }
            }
            this.setDisabled(false);
            this.updateStrategyAutobudget();
            this.strategyModel.validateModel();
        },

        onInvalidForecast: function() {
            this.setDisabled(false);
            this.strategyModel.set('forecast', 'invalid');
            this.elem('StrategyClick').html('&mdash;');
            this.strategyModel.validateModel();
        },

        isForecastValid: function() {
            var forecast = this.model.get('forecast');
            if (!forecast) { return false; }
            return forecast.isValid() && forecast.isReliable
        },


        onPositionChanged: function() {
            var position = this.strategyModel.get('positions_strategy'),
                index = $.inArray(position, ['high', 'middle', 'low']);

            this.setMod('position', position);
            $(this.elem('PositionStrategy')[index]).prop('checked', true);
            this.updateStrategyAutobudget();
        },


        onPositionStrategyClick: function(e) {
            var position = e.data.domElem.val();
            this.setMod('position', position);
            this.strategyModel.update({'positions_strategy': position, is_edited: 1});
            this.updateStrategyAutobudget();

        },

        disablePane: function(disabled) {
        },

        updateStrategyAutobudget: function() {

            if (this.elem('StrategyAutobudget').length < 1 || !this.model.get('forecast')) return;
            var autobudget =this.model.get('forecast').getBudgetForStrategy(BEM.blocks['b-strategy-select-easy'].toServer.strategy[this.getMod('strategy')]);
            this.strategyModel.update({'autobudget_sum': autobudget});
            this.elem('StrategyAutobudget').val(autobudget);
        },

        setDisabled: function(disabled) {
            this.elem('PositionStrategy').prop('disabled', !!disabled);
            if (disabled) {
                this.setMod('disabled', 'yes');
            } else {
                this.delMod('disabled');
            }

        }


    });

    function roundClicks(value) {
        var module = value >= 1000 ? 50 : 10;
        value = Math.round(value);
        return value - value % module;
    }

})(jQuery);


