(function($) {
    BEM.DOM.decl({name: 'b-strategy-select-easy__popup', baseBlock: 'b-popupa'}, {
        onSetMod: {
            js: function() {
                this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy');
                var _this = this;

                this.strategiesModels = {};

                $.each(['easy-week-bundle', 'fast', 'distributed'], function(i, name) {
                    _this.strategiesModels[name.replace(/-/g, '_')] = BEM.blocks['i-models-manager'].get('campaign', 'b-easy-campaign-strategy-' + name);
                });

                this.setMod('adjustable', 'no');
                this.__base();
                this.budgets = {};
                this.bindTo('cancel', 'click', this.onCancel);
                this.bindTo('ok', 'click', this.onSave);

                for (var name in this.strategiesModels) {

                    this.strategiesModels[name].on('error-set error-clear', this.onError, this);
                }

                this.model
                    .onField('strategy', 'change', this.onError, this);


                this.errorMessage = iget("При сохранении бюджета произошла ошибка");
            },

            'direction': function(modName, modVal) {
                $.each(['up', 'down', 'left', 'right'], $.proxy(function(i, name){
                    this.domElem.toggleClass('b-popupa_direction_'+name, name == modVal);
                }, this))

            }
        },

        isStrategyChanged: function() {

            if (this.model.isFieldChanged('strategy')) {
                return true;
            }

            if (this.strategiesModels[this.model.get('strategy')].isChanged('toServer')) {
                return true;
            }
            return false;

        },

        onSave: function() {
            if (!this.isStrategyChanged()) { this.onCancel(); return; }
            this.save();
        },

        onCancel: function() {
            this.hide();
        },



        onError: function() {

            this.elem('ok')
                .prop('disabled', this.strategiesModels[this.model.get('strategy')].hasErrors())
        },

        validate: function() {
            var strategy = this.model.get('strategy');
            if (this.strategiesModels[strategy].validateModel()) {
                return true;
            } else {
                return false;
            }
        },

        fixModelData: function() {
            this.model.fixData();
            var strategy = this.model.get('strategy'),
                strategyModel = this.strategiesModels[strategy];

            if (strategy == 'distributed') {
                strategyModel.set('original_budget', strategyModel.get('manual_autobudget_sum'))
            }
            strategyModel.fixData();
        },

        save: function() {
            var options = this.getSaveOptions();
            if (this.params.ulogin) {
                options.ulogin = this.params.ulogin;
            }

            if (!this.validate()) {
                return false;
            }
            this.model.update({'saving_status': 'process'});
            $.ajax({
                url: "/registered/main.pl",
                dataType: 'json',
                data: options,
                context: this,
                success: function(response){
                    if (response.error){
                        alert(response.error || this.errorMessage);
                        this.model.update({'saving_status': 'error'});
                    } else {
                        this.model.update({'saving_status': 'ok'});
                        this.fixModelData();
                        this.hide();

                    }

                },
                error: function() {
                    alert(this.errorMessage);
                    this.model.update({'saving_status': 'error'});
                }
            });
        },


        setForecast: function(forecast) {
            if (forecast) {
                this.budgets = {
                    'low': forecast.budgetLow,
                    'middle': forecast.budgetMiddle,
                    'high': forecast.budgetHigh
                }
            }
        },


         getSaveOptions: function() {
            var options = {
                cmd: 'ajaxSaveAutobudget',
                pseudo_currency_id: direct.ForecastUtils.getPseudoCurrency().id,
                cid: this.params.cid,
                budget_strategy: this.model.get('strategy')
            };

            if (options.budget_strategy == 'distributed') {
                options.manual_autobudget_sum = this.strategiesModels['distributed'].get('manual_autobudget_sum');

            } else if (options.budget_strategy == 'easy_week_bundle') {
                var strategiesModel = this.strategiesModels['easy_week_bundle'];

                options.autobudget_avg_bid = strategiesModel.get('autobudget_avg_bid');
                options.autobudget_limit_clicks = strategiesModel.get('autobudget_limit_clicks');
                options.easy_week_bundle_sum = strategiesModel.get('easy_week_bundle_sum');
            } else {
                options.positions_strategy = this.strategiesModels['fast'].get('positions_strategy');
                options.autobudget_sum = this.budgets[options.positions_strategy]
            }

            return options;
        }



    });
})(jQuery);




