include('../facade/b-strategy-select__facade.js');
(function($, Lego) {

var serverFacade = Lego.block['b-strategy-select__facade'];

Lego.block['b-strategy-select__ajax'] = function(params) {
    var $this = $(this),
        save = $('.b-ss__save', $this),
        cancel = $('.b-ss__cancel', $this),
        commonModel = params.model,
        model = params.model.models.strategy,
        originalText = save.val(),
        originalData = model.getData();

    save
        .click(function(e) {
            if (check()) {
                setLoading(true);
                $.ajax({
                   url: SCRIPT,
                   dataType: 'json',
                   data: $.extend(value(), { cid: params.cid, cmd: 'ajaxSaveAutobudget', ulogin: params.ulogin }),
                   success: function(response) {
                       if (response.success) {
                          location.reload();
                       } else {
                           alert(response.error || iget('Не удалось сохранить стратегию'));
                           setLoading(false);

                       }
                   },
                   error: function() {
                       alert(iget('Не удалось сохранить стратегию'));
                   }
                });
            }
        })
        .add(cancel).prop('disabled', false);


    $this.data('api', {
        cancel: function() {
            model.update(originalData);
            $this.toggle();
        },
        
        toggle: function() {
            if ($this.is(':visible')) $this.data('api').cancel();
            else $this.toggle();
        }
    });
    
    cancel.click($this.data('api').cancel);
    
    function value () {
        return serverFacade.prepareData(model);
    }
    
    function setLoading (state) {
        save.val(state ? iget('Сохранение...') : originalText)
            .add(cancel).prop('disabled', state);
    }
    
    function check () {
        if (!model.validateModel()) {
            alert(model.getErrorTextForModel());
            return false;
        }
        return true;
    }
    
};
})(jQuery, window.Lego);
