/**
 * Created by JetBrains WebStorm.
 * User: collapsus
 * Date: 8/18/11
 * Time: 12:17 PM
 * To change this template use File | Settings | File Templates.
 */
(function($, Lego) {
    Lego.block['b-strategy-select__blocks__day_budget'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            paramsDB = params.day_budget,
            $set = $('.b-ss__day_budget__day_budget_set', $this),
            $sum = $('.b-ss__day_budget__day_budget_sum', $this),
            $showMode = $('.b-ss__day_budget__day_budget_show_mode', $this),
            $options = $('.b-ss__day_budget__day_budget_options', $this);

        model.bind('reset change.day_budget_sum ', updateInputsByModel);

        function updateInputsByModel() {
            var sum = model.get('day_budget_sum'),
                state = model.get('day_budget_set');

            $sum.val(sum > 0 ? sum : '');

            $showMode.val(model.get('day_budget_show_mode'));

            $set.prop('checked', state);
            updateVisibility(state)
        }

        function updateVisibility(state) {
            $this.toggleClass('disabled', !state);
            $options.css('visibility', state ? 'visible' : 'hidden');
        }


        $set
            .change(function(e, sum){
                if (sum) this.checked = sum > 0;

                var state = this.checked;
                updateVisibility(state);
                model.update({
                    'day_budget_set': state,
                    'day_budget_sum': sum || $sum.val(),
                    'day_budget_show_mode': $showMode.val()
                }, $this);
            })
            .trigger('change', paramsDB.sum);

        $sum.change(function(){
            var max = params.MAX_DAY_BUDGET_DAILY_CHANGE_COUNT;

            // если меняем написание одного и того же числа, например 333.00 => 333, то не обрабатываем change
            if (model.get('day_budget_sum') == this.value) return;

            if (paramsDB.daily_change_count < max) {
                model.update({'day_budget_sum': this.value, 'day_budget_show_mode': $showMode.val()}, $this);
            }
            else {
                alert(iget('Дневной бюджет можно менять не более %s в день.',
                    max + ' ' + common.inflector.pluralizeWord([iget('раза'), iget('раз'), iget('раз')], max)));
                this.value = paramsDB.sum > 0 ? paramsDB.sum : '';
            }
        });

        $(document).bind('day_budget.disable', function(e, state){ $set.add($sum).add($showMode).prop('disabled', state) });

    };
})(jQuery, window.Lego);
