
(function($, Lego) {
    BEM.blocks['b-model'].register('b-strategy-media-all-block-price', {

        fields: {
            'media_all_block_price_bid': {type: 'number', precision: 2, 'default': '', defaultView: ''},

            'currency': {type: 'const', 'default': 'YND_FIXED'}
        },

        validateRules: function(){
            var curr = get_currency(this.get('currency'));
            return {
                'media_all_block_price_bid': {
                    'list': [
                        { id: 'required', name: 'required', text: iget('Не указано значение единой цены для всех объявлений.')},
                        { id: 'format', name: 'format', text: iget('Неверно указано значение единой цены для всех объявлений.')},
                        {
                            id: 'min', name: 'min', value: curr.MIN_AUTOBUDGET_BID,
                            text: iget('Единая цена для всех объявлений не может быть меньше %s', curr.MIN_AUTOBUDGET_BID + ' ' + curr.name)
                        },
                        {
                            id: 'max', name: 'max', value: curr.MAX_AUTOBUDGET_BID,
                            text: iget('Единая цена для всех объявлений не может быть больше %s', curr.MAX_AUTOBUDGET_BID + ' ' + curr.name)
                        }
                    ]
                }
            }
        }
    });

    Lego.block['b-strategy-select__blocks__media_all_block_price'] = function(params) {
        var $this = $(this),
            model = this.model = BEM.blocks['i-models-manager'].get('campaign&strategy:search', 'b-strategy-media-all-block-price'),
            $bid = $('.b-ss__media_all_block_price_bid', $this);

        $bid.change(updateModel);

        model
            .onField('media_all_block_price_bid', 'change', updateInputs)
            .set('currency', params.currency);

        updateInputs();

        function updateModel() {
            model.set('media_all_block_price_bid', $bid.val());
        }

        function updateInputs() {
            $bid.val(model.view('media_all_block_price_bid'));
        }
    };
})(jQuery, window.Lego);
