
(function($, Lego) {
    // стратегия для медиаплана "Сохранить ставки из медиаплана"
    BEM.blocks['b-model'].register('b-strategy-media-banners-prices', {

        fields: {
            'media_banners_prices_percent': {type: 'number', precision: 2, 'default': '', defaultView: ''}
        },

        validateRules: function(){
            return {
                'media_banners_prices_percent': {
                    list: [
                        { id: 'required', name: 'required', text: iget('Не указано значение процента увеличения ставок.')},
                        { id: 'format', name: 'format', text: iget('Неверно указано значение процента увеличения ставок.')}
                    ]
                }
            }
        }
    });

    Lego.block['b-strategy-select__blocks__media_banners_prices'] = function(params) {
        var $this = $(this),
            model = this.model = BEM.blocks['i-models-manager'].get('campaign&strategy:search', 'b-strategy-media-banners-prices'),
            $percent = $('.b-ss__media_banners_prices_percent', $this);

        $percent.change(updateModel);

        model.onField('media_banners_prices_percent', 'change', updateInputs);

        updateInputs();

        function updateModel() {
            model.set('media_banners_prices_percent', $percent.val());
        }

        function updateInputs() {
            $percent.val(model.get('media_banners_prices_percent'));
        }
    };
})(jQuery, window.Lego);
