(function($, Lego) {
    Lego.block['b-strategy-select__blocks__autobudget'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            $cpaSettings = $('.b-ss__autobudget__cpa', $this),
            $goalSelectBlock = $('.b-ss__autobudget__goal-select-block', $this),
            $inputs = {
                sum: $('.b-ss__autobudget__autobudget_sum', $this),
                bid: $('.b-ss__autobudget__autobudget_bid', $this)
            },
            $cpaInputs;


        $inputs.sum.add($inputs.bid).blur(onMoneyInputBlur);


        if ($cpaSettings.length > 0) {
            $cpaInputs = {
                cpaCliksRadio: $('.b-ss__autobudget__cpa-clicks', $cpaSettings).click(updateModel),
                cpaConvRadio: $('.b-ss__autobudget__cpa-conv', $cpaSettings).click(updateModel),
                convSelect: $('.b-ss__autobudget__conv-select', $cpaSettings).change(updateModel),
                convSelectLavel: $('.b-ss__autobudget__conv-select-label', $cpaSettings)
            };

        }

        model
            .bind('reset change.strategy', onStrategyReset)
            .bind('change.autobudget_bid', onBidChange)
            .bind('change.autobudget_sum', onSumChange)
            .bind('change.autobudget_goal_id', onGoalChange);

        updateDomByModel();

        function onBidChange() {
            $inputs.bid
                .val(model.get('autobudget_bid'))
                .parent().toggleClass('b-ss_disabled', !$inputs.bid.val().match(/\S/));
        }

        function onGoalChange() {
            if ($cpaInputs) {
                var isConvChecked = !!$cpaInputs.cpaConvRadio.prop('checked');
                $cpaInputs.convSelect.prop('disabled', !isConvChecked);
                $cpaInputs.convSelectLavel.toggleClass('b-ss_disabled', !isConvChecked);
            }
        }

        function onSumChange() {
            $inputs.sum.val(model.get('autobudget_sum'));
        }

        function onStrategyReset(e) {
            if (e.source != $this && model.get('strategy') == 'autobudget') {
                updateDomByModel();
            }
        }

        function updateDomByModel() {
            updateInputs();
        }

        function onMoneyInputBlur() {
            updateModel();
        }


        function updateModel() {
            var data = {
                strategy: 'autobudget',
                autobudget_bid: $inputs.bid.val(),
                autobudget_sum: $inputs.sum.val()
            };

            if ($cpaInputs) {
                data.autobudget_goal_id = $cpaInputs.cpaCliksRadio.prop('checked')? '' : $cpaInputs.convSelect.val();
            }

            model.update(data, $this);
        }


        function updateInputs() {

            onBidChange();
            onSumChange();

            if ($cpaInputs) {
                var goals = model.get('campaign_goals'),
                    goalId = model.get('autobudget_goal_id');
                $cpaInputs.cpaCliksRadio.prop('checked', goalId === "");
                $cpaInputs.cpaConvRadio.prop('checked', goalId !== "");
                updateGoalsSelect(goals, goalId);

                if (goalId !== "") {
                    $cpaInputs.convSelect.val(model.get('autobudget_goal_id'));
                }
                var disabled = !goals ||
                        model.get('all_counters_deleted') || model.get('all_goals_deleted') ||
                        model.get('count_all_goals') < MIN_GOALS_ON_CAMPAIGN;

                $cpaInputs.convSelect.prop('disabled', disabled || goalId === "");
                $goalSelectBlock.toggleClass('b-ss_disabled', !!disabled);
                $cpaInputs.cpaConvRadio.prop('disabled', disabled);
                onGoalChange();
            }

        }



        function updateGoalsSelect(goals, currentGoalId) {
            var options = '<option value="0">' + iget('всем целям') + '</option>';

            $.each(goals, function(i, v){
                if (v.counter_status == 'Active' && v.goal_status == 'Active' || i == currentGoalId) {
                    var goalClass = v.counter_status == 'Deleted' || v.goal_status == 'Deleted' ? 'b-ss__strategy__goal-deleted' : '',
                        disabled = v.goals_count < MIN_GOALS_ON_CAMPAIGN ? ' disabled' : '';

                    options += '<option value="' + i + '" class="' + goalClass + '"' + disabled + '>' + getGoalName(v) + '</option>'
                }
            });

            $cpaInputs.convSelect.html(options);
        }

        function getGoalName(goal) {
            var name = goal.goal_name;

            if (!name) return '&mdash;';

            var nameLength = goal.counter_status != 'Active' || goal.goal_status != 'Active' || goal.goals_count < MIN_GOALS_ON_CAMPAIGN ? 10 : 15;

            return direct.utils.escapeHTML(name.substr(0, nameLength)) + (goal.goal_name.length > nameLength ? '...' : '') +
                (goal.status == 'Deleted' ? '(' + iget('удалена') + ')' : '') +
                (goal.goals_count < MIN_GOALS_ON_CAMPAIGN ? '(' + iget('мало данных') + ')' : '');
        }

    };
})(jQuery, window.Lego);
