(function($, Lego) {
    Lego.block['b-strategy-select__blocks__avg-click'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            $inputs = {
                avgBid: $('.b-ss__autobudget_avg_click__autobudget_avg_bid', $this),
                sum: $('.b-ss__autobudget_avg_click__autobudget_sum', $this)
           };

        $inputs.avgBid.add($inputs.sum).blur(onMoneyInputBlur);

        $inputs.sum.bind('keyup blur click change', updateDisabled);
        
        model.bind('reset change.strategy', onStrategyChange);
        model.bind('change.autobudget_avg_bid', onBidChange);
        model.bind('change.autobudget_sum', onSumChange);
        updateDomByModel();

        function onBidChange() {
            $inputs.avgBid.val(model.get('autobudget_avg_bid'));
        }

        function onSumChange() {
            $inputs.sum.val(model.get('autobudget_sum'));
            updateDisabled();
        }

        function updateDisabled() {
            $inputs.sum.parent().toggleClass('b-ss_disabled', !$inputs.sum.val().match(/\S/));
        }

        function onStrategyChange(e) {
            if (e.source != $this && model.strategy() == 'autobudget_avg_click') {
                updateDomByModel()
            }
        }

        function updateDomByModel() {
            onBidChange();
            onSumChange();
        }

        function onMoneyInputBlur() {
            updateModel();
        }

        function updateModel() {
            model.update({
                strategy: 'autobudget_avg_click',
                autobudget_avg_bid: $inputs.avgBid.val(),
                autobudget_sum: $inputs.sum.val()
            }, $this);
        }




    };
})(jQuery, window.Lego);
