(function($, Lego) {
    Lego.block['b-strategy-select__blocks__different-places'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            $inputs = {
                select: $this.find('.b-ss__different_places__search_select'),
                hidden: $this.find('.b-ss__different_places__search_hidden'),
                minPriceRadios: $this.find('.b-ss__different_places__radio_min_price'),
                noPremiumRadios: $this.find('.b-ss__different_places__radio_no_premium')
            },
            $minPriceBlock = $this.find('.b-ss__different_places__min-price'),
            $noPremiumBlock = $this.find('.b-ss__different_places__strategy_no_premium');

        var isPopup = $this.parents('.b-window').length > 0;

        $(document).bind('b-window_close-all', function() {
            $inputs.select.trigger('popupsClose.lego')
        });

        model.bind('reset change.strategy', onStrategyChange);
        $inputs.select.bind('select', onSelectChange);
        $inputs.select.bind('popupOpen.lego', onSelectOpen);
        $inputs.minPriceRadios.bind('change blur click', updateModel);
        $inputs.noPremiumRadios.bind('change blur click', updateModel);

        updateDomByModel();

        function onSelectOpen() {
            if (!isPopup) {
                 $(document).trigger('b-window_close-all');
            }
        }

        function onStrategyChange(e) {
            if (e.source != $this && model.strategy() == 'different_places') {
                updateDomByModel()
            }
        }

        function onSelectChange() {
            updateModel();
            updateVisibility();
        }

        function updateDomByModel() {
            updateInputs();
            updateVisibility();
        }


        function updateModel() {
            var data = {};
            data.strategy = 'different_places';
            data.search_strategy = $inputs.select.data('value');

            data.strategy_min_price = data.search_strategy == 'min_price' ? $inputs.minPriceRadios.filter(':checked').val() : '';
            data.strategy_no_premium = data.search_strategy == 'strategy_no_premium' ? $inputs.noPremiumRadios.filter(':checked').val() : '';
            model.update(data, $this);
        }

        function updateVisibility() {
            $minPriceBlock.toggleClass('g-hidden', model.get('search_strategy') != 'min_price');
            $noPremiumBlock.toggleClass('g-hidden', model.get('search_strategy') != 'strategy_no_premium');
        }

        function updateInputs() {
            var searchStrategy = model.get('search_strategy') || 'default';
            $inputs.hidden.val(searchStrategy);
            $inputs.hidden.trigger('change');
            var minPriceValue = model.strategy_min_price() || 'premium';
            $inputs.minPriceRadios.filter('[value=' + minPriceValue + ']').prop('checked', true);
            var noPremiumValue =  model.strategy_no_premium() || 'highest_place';
            $inputs.noPremiumRadios.filter('[value=' + noPremiumValue + ']').prop('checked', true);

        }


    };
})(jQuery, window.Lego);
