(function($, Lego) {
    Lego.block['b-strategy-select__blocks__min-price'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            $minPriceRadios = $('.b-ss__min_price__radio', $this);
        model.bind('reset change.strategy', onStrategyChange);

        $minPriceRadios.bind('change blur click', updateModel);
        updateInputs();

        function onStrategyChange(e) {
            if (e.source != $this && model.strategy() == 'min_price') {
                updateInputs();
            }
        }

        function updateModel(e) {
            model.update({ strategy: 'min_price', strategy_min_price: $minPriceRadios.filter(':checked').val() }, $this);
        }

        function updateInputs() {
            $minPriceRadios.filter('[value=' + (model.strategy_min_price() || 'premium') + ']').prop('checked', true);
        }
    };
})(jQuery, window.Lego);
