(function($, Lego) {
    Lego.block['b-strategy-select__blocks__strategy_no_premium'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            $noPremiumRadio = $('.b-ss__strategy_no_premium__radio', $this);
        

        model.bind('reset change.strategy', onStrategyChange);

        $noPremiumRadio.bind('change blur click', updateModel);
        updateInputs();

        function onStrategyChange(e) {
            if (e.source != $this && model.strategy() == 'strategy_no_premium') {
                updateInputs();
            }
        };

        $noPremiumRadio.bind('change blur click', function () {
            model.update({ strategy: 'strategy_no_premium', strategy_no_premium: $noPremiumRadio.filter(':checked').val() }, $this);
        });

        updateInputs();

        function updateModel(e) {
            model.update({ strategy: 'strategy_no_premium', strategy_no_premium: $noPremiumRadio.filter(':checked').val() }, $this);
        }

        function updateInputs() {
            $noPremiumRadio.filter('[value=' + (model.strategy_no_premium() || 'highest_place') + ']').prop('checked', true);
        }
    };
})(jQuery, window.Lego);
