(function($, Lego) {
    Lego.block['b-strategy-select__blocks__week-bundle'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy;

        var $inputs = {
            limitClicks: $('.b-ss__autobudget_week_bundle__autobudget_limit_clicks', $this),
            avgDropdown: $('.b-ss__autobudget_week_bundle__avg_dropdown', $this),
            avgHidden: $('.b-ss__autobudget_week_bundle__avg_hidden', $this),
            bid: $('.b-ss__autobudget_week_bundle__bid', $this)
        };

        $inputs.limitClicks.bind('blur', updateModel);
        $inputs.bid.bind('keyup blur click change', updateDisabled);
        $inputs.bid.bind('blur', updateModel);
        $inputs.avgDropdown.bind('select', updateModel);

        model.bind('reset change.strategy', onStrategyChange);
        model.bind('change.autobudget_limit_clicks', onLimitClickChanged);
        model.bind('change.autobudget_bid', onBidChanged);
        model.bind('change.autobudget_avg_bid', onBidChanged);
        updateDomByModel();

        function onStrategyChange(e) {
            if (e.source != $this && model.strategy() == 'autobudget_week_bundle') {
                updateDomByModel();
            }
        }

        function onBidChanged() {
            var type = model.autobudget_avg_bid() ? 'avg_bid' : 'bid',
                bid = (type == 'avg_bid') ? model.get('autobudget_avg_bid') : model.get('autobudget_bid');
            $inputs.bid.val(bid);

            updateDisabled();
        }

        function onLimitClickChanged() {
            $inputs.limitClicks.val(model.get('autobudget_limit_clicks'));
        }

        function updateDomByModel() {
            updateInputs();

        }

        function updateModel() {
            var data = {};
            data.strategy = 'autobudget_week_bundle';
            var avgHiddenVal = $inputs.avgHidden.val(), bid = $inputs.bid.val();
            data.autobudget_limit_clicks = $inputs.limitClicks.val();
            data.autobudget_bid = (avgHiddenVal == 'bid') ?  bid : '';
            data.autobudget_avg_bid = (avgHiddenVal == 'avg_bid')? bid : '';
            data.avg_type = avgHiddenVal;
            model.update(data, $this);
        }

        function updateDisabled() {
            $inputs.avgDropdown.toggleClass('b-dropdown-select_theme_light-gray', !$inputs.bid.val().match(/\S/));
            $inputs.bid.parent().toggleClass('b-ss_disabled', !$inputs.bid.val().match(/\S/));
        }

        function updateInputs() {
            var type = model.autobudget_avg_bid() ? 'avg_bid' : 'bid';
            onLimitClickChanged();
            onBidChanged();
            $inputs.avgHidden.val(type);
            $inputs.avgHidden.trigger('change');
        }
    };
})(jQuery, window.Lego);
