(function($, Lego) { 
    var thisBlock = Lego.block['b-strategy-select__facade'] = function(params) {};

    var nomodified = ['strategy', 'autobudget_sum', 'autobudget_avg_bid',
                        'autobudget_limit_clicks', 'autobudget_bid', 'autobudget_goal_id'
        ],
        modified = {
            'strategy_no_premium': function() {
                var strategy = this.get('strategy'),
                    search_strategy = this.get('search_strategy');
                return  strategy == 'different_places' && search_strategy == 'strategy_no_premium' || strategy == 'strategy_no_premium' ? this.get('strategy_no_premium') : '';
            },
            'search_strategy': function() {
                var strategy = this.get('strategy');

                return  strategy == 'different_places' ? this.get('search_strategy') : '';
            },
            'min_price_guarantee': function () {
                var minPrice = this.get('strategy_min_price'),
                    strategy = this.get('strategy'),
                    search_strategy = this.get('search_strategy');
                return strategy == 'min_price' || strategy == 'different_places' && search_strategy == 'min_price' ? minPrice == 'both' ? 1 : 0 : '';
            },
            'min_price_premium': function () {
                var minPrice = this.get('strategy_min_price'),
                    strategy = this.get('strategy'),
                    search_strategy = this.get('search_strategy');
                return strategy == 'min_price' || strategy == 'different_places' && search_strategy == 'min_price' ? minPrice == 'both' || minPrice == 'premium' ? 1 : 0 : '';
            },
            'autobudget': function () {
                var strategy = this.get('strategy');
                return strategy == 'autobudget' || strategy == 'autobudget_avg_click' || strategy == 'autobudget_week_bundle' ? '1' : ''
            }
        },
        modifiedForMediaplan = {
            'media_all_block_price_bid': function() {
                return this.get('strategy') != 'media_all_block_price' ? '' : this.get('media_all_block_price_bid');
            },
            'media_banners_prices_percent': function() {
                return this.get('strategy') != 'media_banners_prices' ? '' : this.get('media_banners_prices_percent');
            }
        };


    thisBlock.prepareData = function(model, forMediaplan) {
        var data = {};

        $.each(modified, function(name, func) {
            data[name] = func.call(model);
        });
        $.each(nomodified, function(i, name) {
            data[name] = model.get(name);
        });
        if (forMediaplan) {
            $.each(modifiedForMediaplan, function(name, func) {
                data[name] = func.call(model);
            });
        }
        return data;
    }

    

})(jQuery, window.Lego);
