include('../facade/b-strategy-select__facade.js');

(function($, Lego) {

var serverFacade = Lego.block['b-strategy-select__facade'];

Lego.block['b-strategy-select__hidden'] = function(params) {

    var $this = $(this),
        model = params.model.models.strategy,
        hiddens = {};

    $('[class^=b-ss__hidden__]', $this).each(function(n, v) {
        hiddens[v.className.match(/b-ss__hidden__(\S+)/)[1]] = v;
    });
    model.bind('reset change', storeHiddens);
    
    function storeHiddens () {
        var data = serverFacade.prepareData(model, params.forMediaplan);

        $.each(data, function(name, value) {
            hiddens[name].value = value;
        });

    }
    storeHiddens();
};
})(jQuery, window.Lego);
