        (function($, Lego) {
            Lego.block['b-strategy-select__hints__autobudget'] = function(params) {
                var $this = $(this),
                    model = params.model.models.strategy,
                    $hints = {
                        'no-data': $this.find('.no-data'),
                        'no-metrika': $this.find('.no-metrika'),
                        'decrease-goal': $this.find('.decrease-goal'),
                        'goal-deleted': $this.find('.goal-deleted'),
                        'domains-count': $this.find('.domains-count'),
                        'default': $this.find('.default')
                    };

                model.bind('reset change.strategy', onStrategyChange);
                updateHints();

                function onStrategyChange(e) {
                    if (e.source != $this && model.strategy() == 'autobudget') {
                        updateHints();
                    }
                }

                function getHintName() {
                    var goals = model.campaign_goals(),
                        goalId = model.autobudget_goal_id(),
                        goal = goals ? goals[goalId] || {} : {};

                    if (!goals || model.all_goals_deleted() || model.all_counters_deleted()) {
                        return 'no-metrika';
                    } else if (model.count_all_goals() < MIN_GOALS_ON_CAMPAIGN && goalId === "") {
                        return 'no-data';
                    } else if (goalId !== "" && goal.goals_count < MIN_GOALS_ON_CAMPAIGN) {
                        return 'decrease-goal'
                    } else if (model.compaign_domains_count() > 2) {
                        return 'domains-count'
                    } else if (goalId !== "" && (goal.goal_status == 'Deleted' || goal.counter_status == 'Deleted')) {
                        return 'goal-deleted'
                    } else {
                        return 'default';
                    }
                }

                function updateHints(){
                    var hintName = getHintName();
                    $.each($hints, function(name, hint) {
                        hint.toggleClass('g-hidden', name != hintName);
                    });
                }



            };
        })(jQuery, window.Lego);
