(function($, Lego) {
    Lego.block['b-strategy-select__hints__different-places'] = function(params) {
        var $this = $(this),
            model = params.model.models.strategy,
            currentStrategy = model.get('strategy'),

            $hints = {
                'from-diff-places': $this.find('.from-diff-places'),
                'to-diff-places': $this.find('.to-diff-places')
            };

        model.bind('reset', onStrategyReset);
        model.bind('change.strategy', onStrategyChange);


        updateHints(currentStrategy);

        function onStrategyChange(e) {
            updateHints(model.get('strategy'));
        }

        function onStrategyReset(e) {
            currentStrategy = model.get('strategy');
            updateHints(currentStrategy);
        }

        function updateHints(strategy) {
            $.each($hints, function(name, hint) {
                var hidden = (name == 'from-diff-places' && currentStrategy != 'different_places') ||
                        (name == 'to-diff-places'  && strategy != 'different_places')
                        || (currentStrategy != 'different_places' && strategy != 'different_places');
                hint.toggleClass('g-hidden', strategy == currentStrategy || hidden)
            })
        }
    };
})(jQuery, window.Lego);
