(function($, Lego) { 

Lego.block['b-tabs'] = function(params) {
    var $this = $(this),
        tabs = $('.b-tabs__li', this),
        targets = $('.b-tabs__target:eq(0) .b-tabs__target__li', $this.parent()),
        input = $('.b-tabs__input'),
        selectedIndex,
        api;

    tabs.click(function() {
        if ($(this).hasClass('b-tabs__li_active')) return;
        api.selectedIndex( $(this).prevAll('.b-tabs__li').length );
        $this.parent().addClass('g-hidden').removeClass('g-hidden'); // для ИЕ DIRECT-13687
    });
    
    $this.data('api', api = {
        selectedIndex: function(index, noCustomEvents) {
            if (index === undefined) return selectedIndex;
            selectedIndex = index;
            tabs.removeClass('b-tabs__li_active');
            targets.removeClass('b-tabs__target__li_active');
            
            tabs.eq(selectedIndex).addClass('b-tabs__li_active');
            targets.eq( selectedIndex ).addClass('b-tabs__target__li_active');
            if (!noCustomEvents) {
                $this.trigger('b-tabs.changed', {
                    selectedIndex: selectedIndex,
                    name: params.tabNames ? params.tabNames[selectedIndex] : null
                });
            }
            if (input.length && params.tabNames) input.val(params.tabNames[selectedIndex]);
            if (params.hash && params.tabNames) location.href = '#' + params.tabNames[selectedIndex];
        }
    });
    
    if (params.hash && params.tabNames) {
        var match = location.href.match(/#(.*)/),
            selected = -1;
        if (match) selected = $.inArray(match[1], params.tabNames); 
        api.selectedIndex( selected < 0 ? 0 : selected );
    } else {
        var selected = tabs.filter('.b-tabs__li_active');
        api.selectedIndex( selected.length ? selected.prevAll('.b-tabs__li').length : 0 );
    }
    $(document).trigger('price-tabs-init');
};
})(jQuery, window.Lego);
