(function($){

BEM.DOM.decl({name:'b-time-targeting-easy', baseBlock: 'b-model-block'}, {
    onSetMod: {
        'js': function(){
            this.initConsts();
            this.initModel();
            this.initData();
            this.bindEvents();

            this.scale = this.findBlockInside('b-time-targeting-scale');
            this.scale.on('change', this.onScaleChange, this);

            this.model.onField('timezone_text', 'change', this.onTimezoneTextChange, this);
            this.model.onField('timeTarget', 'change', this.onTimeTargetChange, this);
            this.model.onField('counter', 'change', this.onCounterChange, this);
            this.model.on('change', function() {
                this.fillToServerFromModel();
            }, this);

            this.bindTo('radio', 'click', this.onRadioClick);

            var type = this.getMod('type');

            this.switchType(type);
            this.onSwitchType();
            this.onCounterChange();

            this.bindTo('timezone-link', 'click', this.openTimezonePopup)
        },

        'type': function(modName, modVal1) {
            this.afterCurrentEvent(this.onSwitchType, this);
        }
    },

    initConsts: function() {
        this._modelPath = 'campaign';
        this._modelName = 'b-time-targeting';
    },

    onScaleChange: function() {
        this.model.update({'timeTarget': this.scale.getValue()});

    },

    onCounterChange: function() {
        this.elem('counter').html(this.model.get('counter'));
    },

    openTimezonePopup: function() {
        if (!this.timezonePopup) {
            this.timezonePopup = this.findBlockInside('b-time-targeting-timezone');
        }
        this.timezonePopup.show();
    },

    onTimezoneTextChange: function() {
        this.elem('timezone-link').html(this.model.get('timezone_text'))
    },

    onTimeTargetChange: function() {
        if (this.switchProcess) { return; }

        var type = this.getMod('type');

        if (type == 'worktime') {
            this.model.set('worktimeTimeTarget', this.model.get('timeTarget'));
        } else if (type == 'other') {
            this.model.set('otherTimeTarget', this.model.get('timeTarget'));

        }
    },

    onSwitchType: function() {
        this.switchProcess = false;

        var type = this.getMod('type');

        if (type == 'worktime') {
            this.__self.trigger('worktime');
        } else if (type == 'other') {
            this.scale.inited || this.scale.init();
            this.scale.setValue(this.model.get('timeTarget'));
            this.scale.selectableInited || this.scale.initSelectable();
        }

        if (type == 'all') {
            this.elem('time-target-working-holiday').attr('disabled', 'disabled');
            this.elem('time-target-holiday').attr('disabled', 'disabled');
        } else {
            this.elem('time-target-working-holiday').removeAttr('disabled');
            this.elem('time-target-holiday').removeAttr('disabled');
        }
    },

    switchType: function(newType, prevType) {
        this.switchProcess = true;
        if (newType == 'worktime') {
            if (prevType == 'all' || (prevType == 'other' && !BEM.blocks['b-time-targeting'].isInseparable(this.model))) {
                this.model.set('timeTarget', (this.model.get('worktimeTimeTarget') || BEM.blocks['b-time-targeting'].WORK_TIME));
            } else {
                this.model.set('worktimeTimeTarget', this.model.get('timeTarget'));
            }
        } else if (newType == 'other') {
            if (prevType == 'all' || !prevType) {
                this.model.set('timeTarget', (this.model.get('otherTimeTarget') || BEM.blocks['b-time-targeting'].WORK_TIME));
            } else {
                this.model.set('otherTimeTarget', this.model.get('timeTarget'));
            }
        } else {
            this.model.set('timeTarget', BEM.blocks['b-time-targeting'].ALL_TIME);
        }
        this.fillToServerFromModel();
        this.model.fixData();
    },

    fillToServerFromModel: function() {
        this.__base();

        var isAll = this.model.get('time_target_preset') == 'all';

        this.elem('time-target-working-holiday').val(isAll ? 0 : this.model.get('time_target_working_holiday'));
        this.elem('time-target-holiday').val(isAll ? 0 : this.model.get('time_target_holiday'))
    },

    onRadioClick: function(event) {
        var type = this.getMod($(event.data.domElem), 'val');
        this.switchType(type, this.getMod('type'));
        this.setMod('type', type);
    }
});

})(jQuery);
