(function($, Lego) {
    var reg = /\s*?percent\d+/; // регэксп для работы с классами percent0 percent10 percent20 ... percent100
    BEM.DOM.decl({name:'b-time-targeting-extend-panel', baseBlock: 'b-model-block'}, {



        initConsts: function() {
           this._modelPath = 'campaign';
           this._modelName = 'b-time-targeting';
        },

        bindEvents: function() {
            this.__base();
            var self = this;
            self.bindTo('scale-selected-coef-color', 'click', function() {
                self.hoveredPseudoLink.click()
            })
            self.bindTo('scale', 'mouseleave', function() {
                self.elem('scale-selected-coef-color').hide();
            });
            self.bindTo('scale-color-tr', 'mouseenter', $.proxy(self.onTrMouseener, self));
            self.bindTo('scale-color-tr', 'hover', function() {
                self.hoveredPseudoLink.toggleClass('hovered');
            });
            self.bindTo('scale-color-tr', 'click', function() {
                self.hoveredPseudoLink.click()
            });

            self.bindTo('scale-percent', 'click', $.proxy(function(e) {
                e.stopPropagation();
                if ($(e.data.domElem).hasClass('g-common__bold')) return false;
                self.elem('scale-percent').removeClass('g-common__bold').addClass('b-pseudo-link');
                self.elem('scale-color-td') // для подсветки выбранного цвета рамкой
                    .find('.b-time-targeting-extend-panel__scale-color')
                    .removeClass('b-time-targeting-extend-panel__scale-color-selected');
                var percent = +$(e.data.domElem).toggleClass('g-common__bold b-pseudo-link').text().replace(/[^\d]/g, ''),
                    code = self.getMod($(e.data.domElem), 'code');
                $(e.data.domElem) // для подсветки выбранного цвета рамкой
                    .parents('.b-time-targeting-extend-panel__scale-color-tr')
                    .find('.b-time-targeting-extend-panel__scale-color')
                    .addClass('b-time-targeting-extend-panel__scale-color-selected');
                self.model.set('timeTargetSelectedCoef', code);
                self.elem('scale-selected-coef-arrow').css('bottom', 17 * percent / 10 - 1 + 'px');
                $(document).trigger('quick-select.disable', !percent);
            }, this));
            self.elem('scale-percent').eq(0).click(); // по умолчанию выбираем 100%




        },

        onTrMouseener: function(e) {
            this.hoveredRow = $(e.data.domElem);
            this.hoveredPseudoLink = this.hoveredRow.find('.b-time-targeting-extend-panel__scale-percent');
            var percent = this.hoveredPseudoLink.text().replace(/[^\d]/g, '');
            this.elem('scale-selected-coef-color')
                .attr('class', this.elem('scale-selected-coef-color').attr('class').replace(reg, '') + ' percent' + percent)
                .show()
                .css('bottom', 17 * percent / 10 - 2 + 'px');
        }

    });


})(jQuery, window.Lego);
