(function($, Lego) {
    BEM.DOM.decl({name:'b-time-targeting-holidays', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.__base();
                this.renderWorktime();
            }
        },

        initConsts: function() {
           this._modelPath = 'campaign';
           this._modelName = 'b-time-targeting';
        },

        bindEvents: function() {
            this.__base();
            a = this;

            this.model.onField('time_target_holiday_dont_show', 'change', this.onDontShowChange, this);
            this.model.onField('time_target_holiday', 'change', this.onHolidayCheckboxChange, this);
            this.domElem.bind('mouseenter mouseleave', this.fixIE);
            this.elem('time-target-working-holiday').bind('mouseenter mouseleave', this.fixIE);
            this.elem('time_target_holiday_dont_show').bind('mouseenter mouseleave', this.fixIE);
        },


        onHolidayCheckboxChange: function() {
            this.toggleMod('hidden', 'yes' , 'no', !this.model.get('time_target_holiday'));
            this.fixIE();
        },

        onDontShowChange: function() {
            var disabled = this.model.get('time_target_holiday_dont_show');
            this.worktime && this.worktime.setDisabled(disabled); //worktime не определен до отрисовки попапа
            this.elem('time-target-holiday-coef').prop('disabled', disabled)
            this.fixIE();
         },

         //ugly fix for DIRECT-16696
        fixIE: function() {
            $('#b-time-targeting__toolbar').css('display', 'block');
            $('#b-time-targeting__toolbar').css('display', '');
        },

        renderWorktime: function() {
            var self = this;
            this.elem('time-container').append(BEM.HTML.build({
                block: 'b-worktime',
                    mods: { validated: 'yes' },
                    mix: [{block: 'b-time-targeting-holidays', elem: 'worktime'}],
                    'hours-only': 1,
                    'hour-from': this.model.get('time_target_holiday_from'),
                    'hour-to': this.model.get('time_target_holiday_to')
            }))
            this.worktime = this.findBlockInside('b-worktime');
            this.onDontShowChange(); //чекаем на случай, если флаг установлен до отрисовки попапа

            this.worktime.getChannel().on('change-time', function(e, time) {
                self.model.update({
                    'time_target_holiday_from': time[0],
                    'time_target_holiday_to': time[2]
                })
            })
        }


    });


})(jQuery, window.Lego);
