(function($){

    var codes = {
        'a': '0%',
        'b': '10%',
        'c': '20%',
        'd': '30%',
        'e': '40%',
        'f': '50%',
        'g': '60%',
        'h': '70%',
        'i': '80%',
        'j': '90%',
        'k': '100%'
    }

BEM.DOM.decl('b-time-targeting-scale', {
    onSetMod: {
        'js': function(){

        },

        'mode': function(modName, modVal) {
            this.switchTitles(modVal == 'extend');
        }
    },

    init: function() {
        var _this = this;

        this.hours = 'ABCDEFGHIJKLMNOPQRSTUVWX'.split('');
        this.days = '1234567'.split('');
        this.codes = 'bcdefghij';

        this.model = BEM.blocks['i-models-manager'].get('campaign', 'b-time-targeting')
            .onField('timeTarget', 'change', function() {
                _this.setValue(_this.model.get('timeTarget'));
            })
            .onField('timeTargetMode timeTargetSelectedCoef', 'change', this.onTimeTargetChanged, this)
            .on('refresh', this.initSelectable, this);

        this.bindTo('mousedown', this.onMouseDown);

        this.onTimeTargetChanged();

        this.hourControls = $.map(this.elem('hour-control'), function(elem) {
            var bemBlock =  _this.findBlockOn($(elem), 'b-form-checkbox');
            return bemBlock.on('change', {block: bemBlock, type: 'hour'}, _this.onGroupChange, _this)
        });

        this.dayControls = $.map(this.elem('day-control'), function(elem) {
            var bemBlock =  _this.findBlockOn($(elem), 'b-form-checkbox');
            return bemBlock.on('change', {block: bemBlock, type: 'day'}, _this.onGroupChange, _this)
        });

        this.inited = true;
    },

    onElemSetMod: {
        'hour': {
            'selected': function(elem, modName, modVal) {
                elem.html(modVal == 'yes' ? '+' : '-');
            }
        }
    },

    onTimeTargetChanged: function() {
        this.code = this.model.get('timeTargetMode') == 'extend' ? this.model.get('timeTargetSelectedCoef') || 'k' : 'k';
    },

    adjustGroupControls: function(type) {
        var _this = this;

        this[type + 'Controls'].map(function(control) {
            var val = control.val(), selected = true;
            _this.elem('hour', type, val).each(function(i, elem) {
                selected = selected && _this.getMod($(elem), 'selected') == 'yes'
            });
            control.setMod('checked', selected ? 'yes': 'no')
        });
    },

    onGroupChange: function(event) {
        var _this = this, block = event.data.block;

        if (block.getMod('focused') != 'yes') { return; }
        var value = block.val(), checked = block.isChecked();
        _this.elem('hour', event.data.type, value).each(function(i, elem) {
            _this.setCodeMod($(elem), checked);
            _this.setMod($(elem), 'selected', checked ? 'yes' : 'no')
        });
        block.setMod('focused', 'no');
        _this.adjustGroupControls(event.data.type == 'hour' ? 'day' : 'hour');
        _this.trigger('change')
    },

    getValue: function() {
        var data = {}, _this = this, value = '';
        this.elem('hour').each(function(i, elem) {
            var $elem = $(elem),
                hour = _this.getMod($elem, 'hour'),
                day = _this.getMod($elem, 'day'),
                code = _this.getMod($elem, 'code') != 'k' && _this.model.get('timeTargetMode') == 'extend' ? _this.getMod($elem, 'code') : '';
            if (_this.getMod($elem, 'selected') == 'yes') {
                data[day] = data[day] || [];
                data[day].push([hour + code]);
            }

        });
        $.each(data, function(day, dayData) {
            value += day + dayData.join('');
        });
        return value;
    },

    initSelectable: function() {
        var _this = this;

        this.data = {};
        $.each(this.elem('hour'), function(i, elem) {
            var $elem = $(elem);
            var pos = $elem.offset();

            $.data(this, "selectable-data", {
                element: elem,
                $element: $elem,
                left: pos.left,
                top: pos.top,
                right: pos.left + $elem.outerWidth(),
                bottom: pos.top + $elem.outerHeight(),
                hour: _this.getMod($elem, 'hour'),
                day: _this.getMod($elem, 'day'),
                code: _this.getMod($elem, 'code')
            });
        });
        this.selectableInited = true;
    },

    setCodeMod: function(elem, selected) {
        var code = selected ? this.code : 'a';
        this.setMod(elem, 'code', code);
        elem[0].title = (this.model.get('timeTargetMode') == 'extend') ? codes[code] : '';
    },

    doSelect: function(data) {
        this.setMod(data.$element, 'selected', this.selected);
        this.setCodeMod(data.$element, this.selected == 'yes');
        this.lastChanged = data;
    },

    switchTitles: function(isExtend) {
        var _this = this, code;
        this.elem('hour').each(function(i, elem) {
            code = _this.getMod($(elem), 'code');
            elem.title = isExtend ? codes[code] : '';
        })
    },

    setSelectParams: function(elem) {
        var isExtMode = this.model.get('timeTargetMode') == 'extend',
            currentCode = this.getMod(elem, 'code'),
            currentSelected = this.getMod(elem, 'selected');

        if (!isExtMode) {
            this.selected = currentSelected == 'yes' ? 'no' : 'yes';
        } else {
            this.selected = currentCode != this.code ?
                this.code == 'a' ? 'no' : 'yes' :
                currentSelected == 'yes' ? 'no' : 'yes';
        }
        if (isExtMode && this.code == 'a') {
            this.selected = 'no';
        }



    },

    onMouseDown: function(event) {
        $(document)
            .bind('mousemove.' + this.__self.getName(), $.proxy(this.onMouseMove, this))
            .bind('mouseup.' + this.__self.getName(), $.proxy(this.onMouseUp, this));
        var target = $(event.target), data = $.data(event.target, "selectable-data");

        if (!target.hasClass('b-time-targeting-scale__hour')) { return }
        this.setSelectParams(target);
        this.doSelect(data);
        event.preventDefault();
    },

    onMouseMove: function(event) {
        var x = event.pageX, y = event.pageY, _this = this;

        if (!_this.lastChanged) return;

        $.each(this.elem('hour'), function(i, elem) {
            var data = $.data(this, "selectable-data");
            if (!data || data.hour == _this.lastChanged.hour && data.day == _this.lastChanged.day) { return; }


            var hit = (data.left < x && data.right > x && data.top < y && data.bottom > y);
            if (hit) {
                _this.doSelect(data)
            }
        });

        return false;

    },

    onMouseUp: function(event) {
        $(document)
            .unbind('mousemove.' + this.__self.getName())
            .unbind('mouseup.' + this.__self.getName());
        this.onChange();

    },

    onChange: function() {
        this.adjustGroupControls('hour');
        this.adjustGroupControls('day');
        this.trigger('change')
    },



    setValue: function(value) {
        var _this = this, regHour, regDay, match, dayMatch, hourMatch, code;
        $.each(this.days, function(i, day) {
            regDay = new RegExp('(' + day + '\\D*)(.*)');
            dayMatch = value.match(regDay) || [];
            value = dayMatch[2] || value;

            $.each(_this.hours, function(i, hour) {
                var elem = _this.elem('hour', 'val', day + '-' + hour);
                if (!dayMatch[1]) {
                   _this.setMod(elem, 'selected', 'no')
                } else {

                    regHour = new RegExp(day + '.*(' + hour + ')([' + _this.codes + ']?).*');
                    hourMatch = dayMatch[1].match(regHour) || [];
                    if (hourMatch[1]) {
                        _this
                            .setMod(elem, 'selected', 'yes')
                            .setMod(elem, 'code', hourMatch[2] || 'k');
                    } else {
                        _this
                            .setMod(elem, 'selected', 'no')
                            .setMod(elem, 'code', 'a');
                    }

                }
                var isExtend = _this.model.get('timeTargetMode') == 'extend';
                if (isExtend && hourMatch) {
                    elem[0].title = codes[hourMatch[1] ? hourMatch[2] || 'k' : 'a'];
                }

            })

        });
        this.onChange();
    }
});

})(jQuery);