(function($, Lego) {

    BEM.DOM.decl({name:'b-time-targeting-timezone', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.timezoneData = this.params.data;
                this.initConsts();
                this.initModel();
                this.bindEvents();
                this.setTimezoneGroup();
            }
        },

        initConsts: function() {
           this._modelPath = 'campaign';
           this._modelName = 'b-time-targeting';
        },

        bindEvents: function() {
            this.bindTo('timezone-id', 'change', this.onTimezoneIdChange);
            this.bindTo('timezone-group', 'change', this.onTimezoneGroupChange);
            this.model.onField('timezone_id', 'change', this.onTimezoneIdExternalChange, this);
            this.model.onField('timezone_group', 'change', this.onTimezoneGroupExternalChange, this)
        },

        onTimezoneGroupExternalChange: function(e, data) {
            if (data && data.source == this) { return; }
            this.elem('timezone-group').val(this.model.get('timezone_group'));
            this.builtSelect(this.model.get('timezone_group'), this.model.get('timezone_id'));
        },

        onTimezoneIdExternalChange: function(e, data) {
            if (data && data.source == this) { return; }
            this.elem('timezone-id').val(this.model.get('timezone_id'));
            this.setTimezoneText();
        },

        setTimezoneText: function() {
            this.model.set('timezone_text', this.elem('timezone-id').find('[value=' + this.model.get('timezone_id') + ']').text());
        },

        onTimezoneIdChange: function() {
            this.model.update({'timezone_id': this.elem('timezone-id').val()}, this);
            this.setTimezoneText();
        },

        onTimezoneGroupChange: function() {
            var group = this.elem('timezone-group').val();
            this.model.update({'timezone_group': group}, this);
            this.builtSelect(group, this.elem('timezone-id').val());
        },

        setTimezoneGroup: function() {
            var groupIdSelected = 0,
                id = this.model.get('timezone_id');
            $.each(this.timezoneData, function(groupId, group) {
                $.map(group, function(el) {
                    if (el.id == id) {
                        groupIdSelected = groupId;
                        return false;
                    }
                })
            });
            this.model.set('timezone_group', groupIdSelected);
            if (groupIdSelected == 0) {
                this.builtSelect(0, id);
            }
        },

        builtSelect: function(timezoneGroup, timezoneId) {
            var selectOptions = [], attrs, data = this.timezoneData[timezoneGroup], value = timezoneId;
            this.elem('timezone-id').empty();
            $.map(data, function(el){
                attrs = value == el.id ? { value: el.id, selected: 'selected'} : {value: el.id};
                selectOptions.push(
                    { tag: 'option', attrs: attrs, content: el.name }
                )
            });
            this.elem('timezone-id').append(BEM.HTML.build(selectOptions));
            this.elem('timezone-id').change();
        }


    });

})(jQuery, window.Lego);
