//Обвязка для профи интерфейса

(function($, Lego) {



var weekdayNames = [iget('Пн.'), iget('Вт.'), iget('Ср.'), iget('Чт.'), iget('Пт.'), iget('Сб.'), iget('Вс.')],
    hoursCodesString = "ABCDEFGHIJKLMNOPQRSTUVWX",
    daysString = "1234567",
    ALL_DAYS = '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX',
    hoursArrayCodes = hoursCodesString.split(''),
    worktimeLimit = 200,
    iModelsManager = BEM.blocks['i-models-manager'];

BEM.DOM.decl({name:'b-time-targeting', baseBlock: 'b-model-block'}, {
    onSetMod : {
        js: function() {
            this.strategyModel = iModelsManager.get('campaign', 'campaign-strategy');
            this.initConsts();
            this.initModel();
            this.bindEvents();
            this.scale = this.findBlockInside('b-time-targeting-scale');



            this.scale.on('change', function() {
                this.model.update({ 'timeTarget': this.scale.getValue()});
            }, this);

            this.initControlsState();

        },

        'mode': function(modName, modVal) {
            this.scale.setMod('mode', modVal)
        }
    },

    initConsts: function() {
       this._modelPath = 'campaign';
       this._modelName = 'b-time-targeting';
    },

    bindEvents: function() {
        this.__base();
        this.extendModeSwitcher = this.findBlockInside('b-form-switch');
        this.extendModeSwitcher.on('change', this.onExtendSwitherClick, this) ;
        this.model
            .onField('counter', 'change', this.setCounter, this)
            .onField('timeTargetMode', 'change', this.onExtendModeSwitch, this);

        this.model.onField('is_autobudget', 'change', this.onStrategyChange, this);

    },

    initControlsState: function() {
        this.onStrategyChange();
        this.setCounter();
    },


    onStrategyChange: function() {
        var isAutobudget = !!this.model.get('is_autobudget');
        this.setMod('no-extend', isAutobudget ? 'yes' : '');


        if (isAutobudget)  {
            if (this.model.get('timeTargetMode') != 'simple') {
                this.prevModData = this.model.memento('input');
                this.model.update({
                    'timeTargetMode': 'simple',
                    'timeTargetSelectedCoef': 'k',
                    'time_target_holiday_coef': 100
                });
            }

        } else {
            if (this.prevModData) {
                this.model.update(this.prevModData);
            }

        }
    },

    onShow: function() {
        //нужно инициализировать уже после того как окно показывается - иначе неправильно определяются расстояния
        this.scale.selectableInited || this.scale.initSelectable();
    },


    onExtendModeSwitch: function(e, data) {
        var mode = !this.model.get('is_autobudget') ? this.model.get('timeTargetMode') : 'simple';
        if (data.source != this) {
            this.extendModeSwitcher.position(mode == 'extend' ? 'left' : 'right')
        }
        this.setMod('mode', mode)
    },

    onExtendSwitherClick: function(e, data) {
        this.model.set('timeTargetMode', data.state == 'left' ? 'extend' : 'simple' , this);
    },

    start: function() {
        if (!this.scale.inited) {
            this.scale.init();
            this.scale.setValue(this.model.get('timeTarget'));
        } else {
            this.onExtendModeSwitch({}, {});
        }
    },


    setCounter: function() {
        var workhours = this.model.get('counter');
        this.elem('counter').html(workhours);
        this.elem('counter-container').toggleClass('counter-error', workhours < 40);
    },






    finish: function() {
        var val = this.scale.getValue();
        this.model.update({ 'timeTarget': val, 'time_target_preset': val == ALL_DAYS ? 'all' : '' }, this);

    },

    onExternalChange: function() {
        this.__self.onExternalChange(this);
        return this;
    }
}, {

    live: true,

    getButtonText: function() {
        return iget('изменить')
    },


    onExternalChange: function(ctx) {
        var model = ctx.model;

        if (model.get('is_autobudget')) {
            model.set('timeTarget', model.get('timeTarget').replace(/[a-z]/g, ''));
        }
    },

    getText: function(ctx, separator, data, is_edge) {
        data = data || ctx.model.getData();
        separator = separator || '<br/>';

        var text = '',
            timeText = this.getDisabledTime(data.timeTarget, is_edge),
            holidayText = '',
            workingHolidayText = '',
            holidayCoef = data.time_target_holiday_coef;

        if (data.time_target_holiday) {
            if (data.time_target_holiday_dont_show == 1) {
                holidayText += iget('По праздникам: не показывать');
            } else if (data.time_target_holiday_from == 0 && data.time_target_holiday_to == 24) {
                holidayText += iget('По праздникам: круглосуточно');
            } else {
                holidayText +=
                    iget('По праздникам: показывать с') + ' ' + data.time_target_holiday_from + ':00 ' +
                    iget('до') + ' ' + data.time_target_holiday_to + ':00' +
                    (data.timeTargetMode != 'simple'&& holidayCoef > 0 && holidayCoef < 100 ?
                        ' (' + iget('ограничение цены клика на уровне') + ' ' + holidayCoef + '%)' :
                        '');
            }
        }
        if (data.time_target_working_holiday){
            workingHolidayText = iget('Рабочие выходные: по расписанию перенесенного буднего дня');
        }
        var timezoneText = '';
        if (data.timezone_id && (timeText != iget('Круглосуточно') || holidayText)) {
            timezoneText = iget('Время') + ': ' + data.timezone_text;
        }

        text += timeText;
        if (holidayText) {
            text += (text ? separator : '') + holidayText;
        }
        if (workingHolidayText) {
            text += (text ? separator : '') + workingHolidayText;
        }
        if (timezoneText) {
            text += (text ? separator : '') + timezoneText;
        }
        return text + (data.timeTarget.match(/[a-z]/) ? separator + iget('Настроены ограничения цены клика.') : '');

    },

    //является ли временной интервал неразрывным - т.е. можно ли его использовать в графе "рабочее время"
    isInseparable: function(model) {
        var timeTarget = model.get('timeTarget').replace(/[a-z]/g, ''),
            daysArray = timeTarget.match(/\d/g),
            hoursArray = timeTarget.split(/\d/);

        if (!daysArray || !hoursArray) {
            return false;
        }
        if (!$.browser.msie) {
            //В ИЕ и остальных браузерах split работает по-разному
            hoursArray = hoursArray.slice(1);
        }

        if (daysString.indexOf(daysArray.join('')) == -1) { return false }
        if (hoursCodesString.indexOf(hoursArray[0]) == -1) { return false }

        for (var i = 1; i < hoursArray.length; i++) {
            if (hoursArray[i] != hoursArray[0]) { return false; }
        }

        return true;

    },

    getDisabledTime: function(string, is_edge) {
        if (!string) { return iget('Круглосуточно'); }

        string = string.replace(/[a-z]/g, '');

        var daysArray = string.match(/\d/g),
            hoursArray = string.split(/\d/);


        if (!daysArray || !hoursArray) {
            return '';
        }
        //is_edge - в ИЕ отключен режим совместимости с ИЕ7
        if (!$.browser.msie || $.browser.version.slice(0,1) > 8) {
            //В ИЕ < 9 и остальных браузерах split работает по-разному
            hoursArray = hoursArray.slice(1);
        }

        var result = '',
            allDays = daysArray.length == 7;
        if (this.isDaysEqual(hoursArray)) {

            var hoursArrayOnly = hoursArray[0].match(/[ABCDEFGHIJKLMNOPQRSTUVWX]/g);
            allDays = allDays && hoursArrayOnly.length == 24;
            result = this.getDaysString(daysArray) + ': ' + this.getHoursString(hoursArray[0])
        } else {
            for (var i = 0; i < daysArray.length; i++) {
                allDays = allDays && hoursArray[i].length == 24;
                result += (result ? ', ' : '') + iget(weekdayNames[daysArray[i] - 1]) + ': ' + this.getHoursString(hoursArray[i]);
            }
        }
        result = allDays ? iget('Круглосуточно') : iget('Показывать') + ': ' + result || iget('Круглосуточно');

        if (result.length > worktimeLimit) {
            result = result.slice(0, worktimeLimit);
            var res = result.match(/(.*),[^,]*$/);
            result = res ? res[1] + '...' : result + '...';

        }
        return result;
    },

    isDaysEqual: function(hoursArray) {
        var hours = hoursArray[0];

        for (var i = 0; i < hoursArray.length; i++) {
            //был странный код, который валился в IE
            if (hours != hoursArray[i]) { return false; }
        }
        return true;
    },

    getDaysString: function(daysArray) {
        var string = iget(weekdayNames[daysArray[0] - 1]);
        var tail = '';
        for (var i = 1; i < daysArray.length; i++) {
            if (daysArray[i] - 1 != daysArray[i - 1]) {
                if (tail) {
                    string += '-' + iget(weekdayNames[tail - 1]);
                    tail = '';
                }
                string += ', ' + iget(weekdayNames[daysArray[i] - 1]);
            } else {
                tail = daysArray[i];
            }
            if (i == daysArray.length - 1 && tail) {
                string += '-' + iget(weekdayNames[tail - 1]);
            }
        }
        return string;
    },

    getHoursString: function(string) {
        var array = string.split(''),
            result = '', mask = [], head, i;

        for (i = 0; i < hoursArrayCodes.length; i++) {
            mask.push($.inArray(hoursArrayCodes[i], array) != -1);
        }

        for (i = 0; i <= mask.length; i++) {
            if ((!mask[i]) && head) {
                result += (result ? ', ' : '') + head + '-' + i + ':00';
                head = null;
                continue;
            }
            if (!head && mask[i]) {
                head = i + ':00';
            }
        }

        return result;
    },
    ALL_TIME: '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX',
    WORK_TIME: '1IJKLMNOPQRST2IJKLMNOPQRST3IJKLMNOPQRST4IJKLMNOPQRST5IJKLMNOPQRST'
});

    BEM.blocks['b-model'].register('b-time-targeting', {
        fields: {
            timeTarget: {type: 'string', input: 1, fromServer: 1, toServer: 1,
                'default': BEM.blocks['b-time-targeting'].ALL_TIME,
                children: ['counter']
            },

            // protected - зарезервированное слово, потому в кавычках
            is_autobudget: {type: 'flag', 'protected': 1},

            //используется только в ЛИ
            worktimeTimeTarget: {type: 'string', fromServer: 1},
            otherTimeTarget: {type: 'string', fromServer: 1},
            //используется только в ЛИ

            timeTargetMode: {type: 'string', fromServer: 1, toServer: 1, 'default': 'simple'},
            timeTargetSelectedCoef: {type: 'string', input: 1},
            time_target_preset: {type: 'string', input: 1, fromServer: 1, toServer: 1, 'default': ''},
            timezone_group: {type: 'number', input: 1, 'default': 0},
            time_target_holiday: {type: 'flag', input: 1, 'default': 0, fromServer: 1, toServer: 1},
            timezone_id: {type: 'string', input: 1, fromServer: 1, toServer: 1, 'default': '130'},
            timezone_text: {type: 'string', input: 1, fromServer: 1, toServer: 1, 'default': iget('Москва')},
            time_target_holiday_coef: {type: 'string', input: 1, fromServer: 1, toServer: 1},
            time_target_holiday_dont_show: {type: 'flag', input: 1, 'default': 0, fromServer: 1, toServer: 1},
            time_target_holiday_from: {type: 'string', input: 1, 'default': 8, fromServer: 1, toServer: 1},
            time_target_holiday_to: {type: 'string', input: 1, 'default': 20, fromServer: 1, toServer: 1},
            time_target_working_holiday: {type: 'flag', input: 1, fromServer: 1, toServer: 1},
            counter: {type: 'number',
                calcValue: function() {
                    var timeTarget = this.get('timeTarget'),
                        days = timeTarget ? timeTarget.match(/([1-5]\D*)/g) : [],
                        counter = 0, hours = '';

                    if (days && days.length) {
                        $.map(days, function(day) {
                            hours = day.match(/[ABCDEFGHIJKLMNOPQRSTUVWX]/g)
                            counter += hours ? hours.length : 0;
                        });
                        return counter;
                    } else {
                        return 0;
                    }
                }
            }
        },

        validateRules: {
            'counter': {
                list: [
                    {
                        name: 'min',
                        id: 'min',
                        type: 'error',
                        value: 40,
                        text: iget('Кампания должна быть включена не менее 40 часов в рабочие дни')
                    }

                ]

            }
        }
    });

})(jQuery, window.Lego);
