 /*
 * С префиксом utils_ - служебные функции работают исключительно для перевода форматов и т.п.
 */

var dayNamesSelectFrom = ('понедельника вторника среды четверга пятницы субботы воскресенья').split(' ');
var dayNamesSelectTo   = ('понедельник вторник среду четверг пятницу субботу воскресенье').split(' ');



function utils_add0(a) {
    return a < 10 ? '0' + a : a;
}

function utils_fillDaySelects(fromSelect, toSelect, noEvent) {
     if (fromSelect.find('options').length == 0) {
         for (var i = 0, l = dayNamesSelectFrom.length; i < l; i++) {
             fromSelect.append($('<option value = "' + (i + 1) + '">' + iget(dayNamesSelectFrom[i]) + '</option>'));
         };
     }
     utils_updateDaySelects(fromSelect, toSelect, noEvent);
}



function utils_updateDaySelects(fromSelect, toSelect, noEvent) {
     var i, l;
     var value = fromSelect.val() * 1 || 0;
     var originalValue = toSelect.val();
     originalValue = (originalValue && originalValue >= value) ? originalValue : value;

     toSelect.empty();

     for (i = value - 1, l = dayNamesSelectTo.length; i < l; i++) {
        toSelect.append($('<option value = "' + (i + 1) + '">' + iget(dayNamesSelectTo[i]) + '</option>'));
     };

     toSelect.val(originalValue);
     !noEvent && toSelect.change();
}

function utils_fillHourSelects(fromSelect, toSelect, fromValue, toValue, noEvent) {
     if (fromSelect.find('option').length == 0) {
         for (var i = 0; i < 24; i++) {
             fromSelect.append($('<option value="' + i + '">' + utils_add0(i) + ':00' + '</option>'));
         };
         fromSelect.val(fromValue)
     }

     utils_updateHourSelects(fromSelect, toSelect, fromValue, toValue, noEvent);
}

function utils_updateHourSelects(fromSelect, toSelect, fromValue, toValue, noEvent) {
     var value = fromValue * 1 || fromSelect.val() * 1 || 0;
     var originalValue = toValue || toSelect.val();
     originalValue = (originalValue && originalValue > value) ? originalValue : value + 1;
     toSelect.empty();
     
     for (var i = value + 1; i <= 24; i++) {
         toSelect.append($('<option value="' + i + '">' + utils_add0(i) + ':00' + '</option>'));
     };

     toSelect.val(originalValue);

     !noEvent && toSelect.change();
}
