include('../../../js/jq/common/template.js');
include('../utils.js');

(function($, Lego) {
Lego.block['b-time-targeting__worktime'] = function(params) {
    var $this = $(this);
    var isInit = false,
        initOnLoad = params.initOnLoad,
        timetargetModel = BEM.blocks['i-models-manager'].get('campaign', 'b-time-targeting'),
        prefix = (new Date()).getTime(),
        parent = $('.b-time-targeting'),
        hoursArray = "ABCDEFGHIJKLMNOPQRSTUVWX".split('');


    var templatesWorktime =  '<div><p>'
        + iget('С%sпо%s', '<select id="${prefix}_day_from"></select>', '<select id="${prefix}_day_to"></select>')
        + '</p><p>'
        + iget('С%sдо%s', '<select id="${prefix}_hour_from"></select>', '<select id="${prefix}_hour_to"></select>')
        + '</p>'
        + '</div>';


    BEM.blocks['b-time-targeting-easy'].on('worktime', onShowWorktime)
    


    function onShowWorktime() {
        if (!isInit) { createWorktime();  isInit = true; }

        fillWorktime(timetargetModel.get('timeTarget'));
    }

    function updateValue() {
        var dayFrom = $('#' + prefix + '_day_from').val() * 1;
        var dayTo = $('#' + prefix + '_day_to').val() * 1;

        var hourFrom = $('#' + prefix + '_hour_from').val() * 1;
        var hourTo = $('#' + prefix + '_hour_to').val() * 1;

        var value = '';
        for (var i = dayFrom; i <= dayTo; i++) {
            value += i;
            for (var j = hourFrom; j < hourTo; j++) {
                 value += hoursArray[j];
            }
        }
        var counter = (dayTo - dayFrom + 1) * (hourTo - hourFrom);
        timetargetModel.update({timeTarget: value, counter: counter}, $this);
    }

    function onDayFromChange() {
        utils_updateDaySelects($('#' + prefix + '_day_from'), $('#' + prefix + '_day_to'));
        updateValue();
    }

    function onHourFromChange() {
        utils_updateHourSelects($('#' + prefix + '_hour_from'), $('#' + prefix + '_hour_to'));
        updateValue();
    }



    function fillWorktime(value) {
        //в строке вида 1АBCD2ABCD3ABCD все времена работы одинковые и нет пропущенных дней
        var hoursCodesRes = value.match(/(?:\d)([A-Za-z]+)(?:\d)?/);
        var hoursCodes = (hoursCodesRes) ? hoursCodesRes[1].split('').sort() : [];
        
        var daysRes = value.match(/\d/g);
        var days = (daysRes) ? daysRes.sort() : [];
        var dayFrom = days[0],
            dayTo = days[days.length - 1],
            hourFrom = $.inArray(hoursCodes[0], hoursArray),
            hourTo = $.inArray(hoursCodes[hoursCodes.length - 1], hoursArray) + 1;

        if (dayFrom == -1) {
            dayFrom = 1; dayTo = 5;
        }
        if (hourFrom == -1) {
            hourFrom = 8; hourTo = 20;
        }
        $('#' + prefix + '_day_from').val(dayFrom);
        $('#' + prefix + '_hour_from').val(hourFrom);
        utils_updateDaySelects($('#' + prefix + '_day_from'), $('#' + prefix + '_day_to'), 1);
        utils_updateHourSelects($('#' + prefix + '_hour_from'), $('#' + prefix + '_hour_to'), hourFrom, hourTo, 1);

        $('#' + prefix + '_day_to').val(dayTo);
        $('#' + prefix + '_hour_to').val(hourTo);

    }

    


    function createWorktime() {
        $this.html(common.template.evaluate(templatesWorktime, {prefix: prefix}));
        
        utils_fillDaySelects($('#' + prefix + '_day_from'), $('#' + prefix + '_day_to'), 1);
        utils_fillHourSelects($('#' + prefix + '_hour_from'),  $('#' + prefix + '_hour_to'), 1);

        $('#' + prefix + '_day_from').change(onDayFromChange);
        $('#' + prefix + '_hour_from').change(onHourFromChange);

        $('#' + prefix + '_day_to').change(updateValue);
        $('#' + prefix + '_hour_to').change(updateValue);
    }

};
})(jQuery, window.Lego);
