/**
 * Псевдоссылка переключающаяся при клике в инпут (для страницы оплаты рекламной кампании)
 */

(function($){

var format = function(val) {
    return common.number.format(common.number.clear(val || 0, { fail: 0, precision: 2 }), { precision: 2 });
};

BEM.DOM.decl('b-toggle-input', {
    onSetMod: {
        'js': function(){
            this.input = this.findBlockOn('input', 'b-form-input')
                .on('change', function(e, dontTrigger){
                    var val = format(this.input.val());

                    this.elem('link').text(val);
                    !dontTrigger && this.trigger('change', val);
                }, this)
                .on('blur', function() {
                    this.input.val(format(this.input.val()));
                }, this)
        }
    },

    set: function(val, dontTrigger){
        this.input.val(format(val), dontTrigger);
    },

    toggle: function(condition){
        this.toggleMod('mode', 'input', 'link', condition);

        this.afterCurrentEvent(function(){
            this.input.setMod('focused', condition ? 'yes' : '');
        });
    }

}, {

    live : function() {

        this.liveBindTo('link', 'leftclick', function(){ this.trigger('click').toggle(true) });

    }

});

})(jQuery);
