(function($, Lego) {

Lego.block['b-toggle_mode_simple'] = function(params) {
    var $parent = params.parent || $(this),
        handle = $('.b-toggle__handle', $parent),
        state = params.state,
        container =  $('.b-toggle__container', $parent),
        openedText = params.openedText || "-",
        closedText = params.closedText || "+";

    handle.click(onHandleClick);

    if (state) {
        if (state == 'collapsed') {
            handle.html(closedText);
            container.addClass('g-hidden')
        } else {
            handle.html(openedText);
            container.removeClass('g-hidden')
        }
    }

    function onHandleClick() {
        var isClosed = container.hasClass('g-hidden');
        handle.html(isClosed ? openedText : closedText);
        container.toggleClass('g-hidden')
    }

};
})(jQuery, window.Lego);