include('../../js/jq/direct/userOptions.js');

(function($, Lego) { 
    
Lego.block['b-toggle'] = function(params) {
    var $this = $(this),
        handles = $('.b-toggle__handle', $this);
    
    handles.click(function(e) {
        e.preventDefault();
        toggle(this);
    });
    
    restore();
    
    function toggle (handle, doNotStore) {
        var handleName = getHandleName(handle),
            opened = isOpened(handleName),
            suffix = (handleName ? '-' + handleName : '');
            
        $this
            .toggleClass('closed' + suffix, opened)
            .toggleClass('open' + suffix, !opened);
        
        if (!doNotStore) store(!opened, handleName);
    }
    
    function store (isOpened, handleName) {
        var name = params.storeName + (handleName ? '-' + handleName : '');
        if (name) {
            var names = $.grep(
                    (direct.UserOptions.get('toggle') || '').split('|'),
                    function(cur) { return cur && cur != '-' && cur != name; }
                );
                
            if (!isOpened && $.inArray(name, names) == -1) {
                names.push(name);
            }
            direct.UserOptions.set('toggle', names.join('|') || '-');
        }
    }
    
    function restore () {
        if (params.storeName) {
            var map = {},
                names = (direct.UserOptions.get('toggle') || '').split('|');
            
            handles.each(function() {
                var handleName = getHandleName(this);
                if (map[handleName || '-']) return;
                
                map[handleName || '-'] = true;
                var name = params.storeName + (handleName ? '-' + handleName : ''),
                    shouldBeOpened = $.inArray(name, names) != -1;
                if (shouldBeOpened == isOpened(handleName)) toggle(this, false);
            });
        }
    }
    
    function isOpened (handleName) {
        var suffix = (handleName ? '-' + handleName : '');
        return !$this.hasClass('closed' + suffix);
    }
    
    function getHandleName(handle) {
        var match = handle.className.match(/handle-(\S+)/);
        return match ? match[1] : '';
    }
    
    
};
})(jQuery, window.Lego);