(function($, Lego) {
Lego.block['b-validator__limit'] = function(params) {
    var $this = $(this),
        model2 = BEM.blocks['i-models-manager'].get(params.modelPath, 'b-banner-edit'),
        fieldName = params.fieldName,
        limit = params.limit,
        useTemplate = params.useTemplate,
        counter = $this.find('.counter');

    model2.onField(fieldName, 'change', updateView)
    updateView(true);

    function getValue() {
        switch(fieldName) {
            case 'extra_message':
                return model2.getChildModel('b-vcard-form').get('extra_message');
            case 'href':
                return model2.getChildModel('b-banner-form-href').get('href');
            default:
                return model2.get(fieldName)
        }
    }

    function updateView(isFirstUpdate) {         
        var value = getValue() || '', l;
        //текст приходит с сервера с замененными спецсимволами - для корректного подсчёта надо перекодировать обратно
        if (isFirstUpdate) {
            value = direct.utils.unescapeHTML(value);
        }
        
        if (value) {
            value = value
                .replace(/[\s\xA0]{2,}/g, " ")
                .replace(/[\s\xA0]$/, "")
                .replace(/^[\s\xA0]/, "");
        }

        if (useTemplate && value) {
            if (value.match(/(\#)([^\#]*)(\#)/)) {
                value = value.replace(/(\#)([^\#]*)(\#)/g, '$2');
            }
        }

        l = value ? value.length : 0;
        counter
            .text(limit - l)
            .toggleClass('b-validator-limit-error', (limit - l) < 0);
    }


};
})(jQuery, window.Lego);
