(function($) {
    var BLUR_TIMEOUT = 1;
    //utility - вспомогательное поле
   //server - отправляется на сервер
   //serverName - имя для хранения на сервере
   //input - напрямую вводится пользователем

   BEM.blocks['b-model'].register('b-vcard-form-address', {
       fields: {
           'street': {type: 'string', fromServer: 1, toServer: 1, input: 1},
           'house': {type: 'string', fromServer: 1, toServer: 1, input: 1},
           'build': {type: 'string', fromServer: 1, toServer: 1, input: 1},
           'apart': {type: 'string', fromServer: 1, toServer: 1, input: 1}

       }
    });

    BEM.DOM.decl({name:'b-vcard-form-address', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.focused = false;
                this.vcardModel =  BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-vcard-form');
                this.__base();

            }
        },

        initConsts: function() {
           this._modelPath = this.params.modelPath;
           this._modelName = 'b-vcard-form-address';
        },

        getText: function() {
            var text = '';
            if (this.model.get('street'))  {
                text += this.model.get('street') + ', ' + this.model.get('house')
            }
            if (this.model.get('build')) {
                text += ', ' + iget('строение') + ' ' + this.model.get('build')
            }
            if (this.model.get('apart')) {
                text += ', ' + iget('офис') + ' ' + this.model.get('apart')
            }
            return text;
        },

        bindEvents: function() {
            this.__base();
            $.each(this.model.getFieldsNames('input'), $.proxy(function(i, name) {
                var elemName = this.model.getElemName(name), self = this;
                if (this.elem(elemName).length > 0 ) {
                    this.getControl(name).bem
                        .on('focus', function() { this.model.debounceTrigger('startEditing') }, this)
                        .on('blur', function() { this.model.debounceTrigger('finishEditing') }, this)
                }
            }, this));
            this.vcardModel.on('change', function() {
                this.elem('correctedstreet').val(this.correctedStreet());
            }, this);
            this.model.on('change', function() {
                this.elem('correctedstreet').val(this.correctedStreet());
            }, this);
        },


        // DIRECT-13563
        correctedStreet: function(addr) {
           var addr = addr || this.model.get('street'),
               filterChars = /[^0-9a-z\u0430-\u044F\u0451'\-]/ig,  // \u0430-\u044F\u0451 == а-яё
               filteredCity = this.vcardModel.get('city').replace(filterChars, '').replace(/\-/g, '\\-'),
               filteredCountry = this.vcardModel.get('country').replace(filterChars, '').replace(/\-/g, '\\-'),
               countryCityRe = new RegExp(
                   '^\\s*(?:'
                 + filteredCountry
                 + '\\s*,?)?\\s*(?:г\\.?\\s*|город\\s+)?'
                 + filteredCity
                 + '(?:$|[ ,;.]+)',
               'i'),
               postalIndexRe = /\b\d{6}\b\s*,?\s*/g;

           return addr.replace(postalIndexRe, '').replace(countryCityRe, '');
        },




        key: function() {
            return getModelKey(this.vcardModel, this.model);
        }
    });



    var ADDRESS_STREET_PREFIXES_RE = new RegExp('(^|\\s|[.,])(' + ADDRESS_STREET_PREFIXES + ')($|\\s|[.,])');

    function getModelKey (vcardModel, addressModel) {
        var street = addressModel.get('street');
        if (!ADDRESS_STREET_PREFIXES_RE.test(street)) street = iget('ул.') + street;
        return [vcardModel.get('country'), vcardModel.get('city'), street, addressModel.get('house'), addressModel.get('build')].join(',');
    }
})(jQuery);

