(function($) {
    var iModelManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl({name:'b-vcard-form-copy'}, {
        onSetMod : {
            js: function() {
                var self = this;
                this.fields = {
                    'main': 'b-vcard-form',
                    'address': 'b-vcard-form-address',
                    'map' : 'b-vcard-form-map',
                    'worktime': 'b-vcard-form-worktime',
                    'ogrn': 'b-ogrn-input'
                };

                this.models = {};
                $.each(this.fields, function(name, modelName) {
                    self.models[name] = iModelManager.get(self.params.modelPath, modelName)
                });

                if (this.params.prevModelPath) {
                    this.prevModels = {};
                    $.each(this.fields, function(name, modelName) {
                        self.prevModels[name] = iModelManager.get(self.params.prevModelPath, modelName)
                    });
                } else if (this.params.prevModelData) {
                    this.prevModelData = this.params.prevModelData;
                }


                this.bindTo('clear-link', 'click', function(e) {
                    e.preventDefault();
                    self.models.main.clear(self, 1);

                    return false;
                })

                this.bindTo('copy-link', 'click', function(e) {
                    e.preventDefault();
                    if (self.prevModelData && !$.isEmptyObject(self.prevModelData)) {
                        $.each(self.models, function(name, model) {
                            model.reset(self.prevModelData, self);
                        });
                    } else {
                        if ($.isEmptyObject(self.prevModels) && !confirm(iget('Будет скопирована пустая визитка'))) {
                            return false;
                        }
                        $.each(self.models, function(name, model) {
                            model.reset(self.prevModels[name].memento(), self);
                        });
                    }

                    self.models.main.trigger('copy');

                    return false;
               })
            }
        }

    });



})(jQuery);

