(function($) {
    var TEXTS = {
        exact:    iget('определено с точностью до дома'),
        number:   iget('определено с точностью до дома, корпус не найден'),
        near:     iget('определено с точностью до дома, корпус не найден'),
        street:   iget('определено с точностью до улицы'),
        manual:   iget('установлено вручную'),
        error:    iget('ошибка при определении адреса; попробуйте сохранить изменения и заново открыть страницу редактирования'),
        empty:    iget('не определено'),
        other:    iget('не определено, адрес не найден')
    },

    cache = {};

    BEM.blocks['b-model'].register('b-vcard-form-map', {
          fields: {
              'manual_point': {type: 'string', fromServer: 1, toServer: 1, input: 1},
              'manual_bounds': {type: 'string', fromServer: 1, toServer: 1, input: 1},
              'is_auto_point': {type: 'string', toServer: 1, input: 1},
              'auto_point': {type: 'string', fromServer: 1, toServer: 1, input: 1},
              'auto_bounds': {type: 'string', fromServer: 1, toServer: 1, input: 1},
              'auto_precision': {type: 'string', fromServer: 1, toServer: 1, input: 1},
              'request_status': {type: 'string', utility: 1, 'default': 'success'},
              'metro': {type: 'string', fromServer: 1, toServer: 1, input: 1},
              'disable_metro': {type: 'flag', fromServer: 1, toServer: 1, input: 1}
          }
      });

    var iModelManager = BEM.blocks['i-models-manager'];

    BEM.DOM.decl({name:'b-vcard-form-map', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.vcardModel = iModelManager.get(this.params.modelPath, 'b-vcard-form');
                this.campModel = iModelManager.get(this.params.modelPath, 'b-campaign-edit');
                this.cid = this.params.cid;
                this.ulogin = this.params.ulogin;
                this.__base();
                this.address = this.addressModel.memento();
                this.redraw();
                this.model.set('is_auto_point', +!this.isManual() + '');
            }
        },

        initConsts: function() {
           this._modelPath = this.params.modelPath;
           this._modelName = this.__self.getName();
           this.isMediaplan = this.params.isMediaplan;
           this.addressModel =  iModelManager.get(this._modelPath, 'b-vcard-form-address');
        },

        onModelCopy: function(e) {
            var newAddress = this.addressModel.memento();
            this.prevAddressData = newAddress;
            this.address = newAddress;
            this.redraw();
        },

        onModelDataChanged: function(e) {
            if (e && e.source == this) return;

            var newAddress = this.addressModel.memento();

            this.prevAddressData = null;
            this.model.clear(this);
            if (this.addressModel.isDataChanged(this.address) || this.vcardModel.isDataChanged(this.address)) {
                if (!this.isManual() && newAddress && !this.isMediaplan) {
                    this.prevAddressData = newAddress;
                    this.address = newAddress;
                }
            }
            this.redraw();

            return this;
        },

        bindEvents: function() {
            this.__base();
            this.vcardModel
                .onField('city', 'finishEditing', this.onModelDataChanged, this)
                .onField('country', 'finishEditing', this.onModelDataChanged, this);
            this.addressModel.on('finishEditing', this.onModelDataChanged, this);
            this.vcardModel.on('copy clear', this.onModelCopy, this);

            var self = this;
            this
                .bindTo('refine', 'click', function() {
                   self.setOpened(true);
                   self.redraw();
                })
                .bindTo('clear', 'click', function() {
                    self.model.update({
                        manual_point: '',
                        manual_bounds: '',
                        is_auto_point: '1'
                    }, self);
                    self.redraw();
                })
                .bindTo('moveToFound', 'click', function() {
                    self.model.update(self.prevAddressData, self);
                    self.prevAddressData = null;
                    self.redraw();
                })
                .bindTo('close', 'click', function() {
                   self.setOpened(false);
                });

        },


        onPlacemarkMove: function() {
            this.prevAddressData = null;

            var point = this.placemark.geometry.getCoordinates(),
                        mapGeometry = this.map.getBounds();
            this.model.update({
                manual_point: point[1] + ',' + point[0],
                is_auto_point: '0',
                manual_bounds: [mapGeometry[0][1], mapGeometry[0][0], mapGeometry[1][1], mapGeometry[1][0]].join(',')
            }, this);
            this.redraw(true);
        },



        /* Визуалка */

        setOpened: function(state) {
            this.toggleMod('open', 'yes', 'no', !!state);
        },

        setLoading: function(state) {
            this.toggleMod('loading', 'yes', 'no', !!state);
        },

        updateMap: function() {
            if ( this.getMod('open') != 'yes' ) return;
            if (!this.map) {
                this.map = new ymaps.Map(this.elem('map')[0], {
                    center: [55.74954, 37.621587],
                    zoom: 10
                });
                this.map.controls.add("typeSelector")
                    .add("zoomControl", { top: 0, left: 0 });

                this.placemark = new ymaps.Placemark([0, 0], {
                    iconContent: iget('Передвиньте метку')
                }, {
                    preset: 'twirl#lightblueStretchyIcon',
                    draggable: 1,
                    hasBalloon: 0
                });

                this.map.geoObjects.add(this.placemark);

                // Создание обработчика для отслеживания перемещения плейсмарка
                this.placemark.events.add("dragend",  this.onPlacemarkMove, this);
            }

            var self = this;
            //DIRECT-9629
            setTimeout(function() {
                self.map.setBounds(self.bounds_ymaps());
                self.placemark.geometry.setCoordinates(self.point_ymaps());
            }, 100)

        },

        redraw: function(skipMapUpdate) {
            if (!this.addressModel.isModelEmpty('input') && !this.isMapPointLoaded()) {
                this.setLoading(true);
                this.findPoint(function(reqAddress) {
                    this.setLoading(false);
                    // если пришел ответ на не тот запрос, или вообще запрос не прошел ничего не делаем
                    if (this.addressModel.isDataChanged(reqAddress) || this.vcardModel.isDataChanged(reqAddress)) return;
                    this.finishRedraw(skipMapUpdate);
                });
            } else {
                this.finishRedraw(skipMapUpdate);
            }
        },

        finishRedraw: function(skipMapUpdate) {
            var subStat =
                    this.addressModel.isModelEmpty('input') ?
                        'empty' :
                        this.model.get('request_status') != 'success' ?
                            'error' :
                            '',

                text = subStat || (this.isManual() ? 'manual' : this.model.get('auto_precision')),

                status = subStat || (this.isManual() || this.model.get('auto_precision') == 'exact' ? 'ok' : 'near');
            this.elem('result').html(iget(TEXTS[text] || TEXTS.other));

            this.setMod('status', status);

            if (status == 'empty' || status == 'error') {
                this.setOpened(false);
            } else {
                if (this.getMod('open') == 'yes') this.redrawPositionText();
                this.elem('refine').html(this.isManual() ? iget('уточнить положение') : iget('установить вручную'));
                this.toggleMod('warning', 'yes', 'no', !!this.prevAddressData)
            }
            skipMapUpdate ? this.model.trigger('finishEditing.placemark') : this.model.trigger('finishEditing.map');
            if (!skipMapUpdate) this.updateMap();
        },


        redrawPositionText: function() {
            if (!this.prevAddressData && this.isManual()) {
                var point1 = this.auto_point_ymaps(),
                    point2 = this.manual_point_ymaps(),
                    distance = ymaps.coordSystem.geo.getDistance(point1, point2);
                this.elem('position').html(
                    iget('в') + ' ' + ymaps.formatter.distance(distance) + ' ' +
                    iget('от найденной точки')
                );
                this.elem('clear').html(iget('вернуть в найденную точку'));
                this.setMod('moved', 'yes')
            } else {
                this.delMod('moved')
            }
        },

        isManual: function() {
            return !!this.model.get('manual_point') && this.model.get('auto_point') != this.model.get('manual_point');
        },

        // конвертеры строчек в объекты YMaps.*
        getPointYmaps: function(name){
            var val = this.model.get(name),
                parts = val.split(',');
            return val && [parts[1], parts[0]];
        },

        manual_point_ymaps: function() {
            return this.getPointYmaps('manual_point');
        },

        auto_point_ymaps: function() {
            return this.getPointYmaps('auto_point');
        },

        point_ymaps: function() {
            return this.manual_point_ymaps() || this.auto_point_ymaps();
        },

        point: function() {
            return this.model.get('manual_point') || this.model.get('auto_point');
        },

        getBoundsYmaps: function(name){
            var val = this.model.get(name),
                parts = val.split(',');
            return val && [
                [parts[1], parts[0]],
                [parts[3], parts[2]]
            ];
        },

        manual_bounds_ymaps: function() {
            return this.getBoundsYmaps('manual_bounds');
        },

        auto_bounds_ymaps: function() {
            return this.getBoundsYmaps('auto_bounds');
        },

        bounds_ymaps: function() {
            return this.manual_bounds_ymaps() || this.auto_bounds_ymaps();
        },

        bounds: function() {
            return this.model.get('manual_bounds') || this.model.get('auto_bounds');
        },

        findPoint: function(callback) {
            var self = this;
            var address = this.addressModel.memento();
            address.city = this.vcardModel.get('city');
            address.country = this.vcardModel.get('country');

            //DIRECT-22997 Не деактивируется чек-бокс в визитке "не показывать на поиске" станцию метро
            if (cache[$.stringify(address)] && cache[$.stringify(address)].metro !== '0') {
                self.model.update(cache[$.stringify(address)], self);
                callback.call(this, cache[$.stringify(address)]);
                return;
            }

            if (self.model.get('auto_bounds')) {
                callback.call(this, this.addressModel.memento());
            } else if (this._loading) {
                this._callbacks.push(callback);
            } else {
                this._loading = true;
                this._callbacks = [callback];

                $.ajax({
                    type: "POST",
                    url: '/registered/main.pl',
                    dataType: 'text',
                    data: $.extend({
                        cmd: 'ajaxValidateStreet',
                        cid: self.campModel.get('cid') || self.cid,  //визитка есть не только у кампании
                        ulogin: self.campModel.get('ulogin') || self.ulogin
                    }, address),

                    complete: $.proxy(function(xhr, s) {
                        if (s == 'success') {
                            try {
                                var data = eval('(' + xhr.responseText + ')');  //избавиться после DIRECT-19297
                                var result = {
                                    request_status: 'success',
                                    auto_precision: data.auto_precision,
                                    auto_bounds: data.auto_bounds,
                                    auto_point: data.auto_point,
                                    //если были записаны вручную метро и ручные границы - мы их не перезаписываем
                                    metro: this.model.get('metro') || (data.metro || {}).region_id || '',
                                    manual_point: this.model.get('manual_point') || data.manual_point,
                                    manual_bounds: this.model.get('manual_bounds') || data.manual_bounds
                                }
                                cache[$.stringify(address)] = result;
                                self.model.update(result, self);
                            } catch (e) {
                                self.model.update({
                                    request_status: 'invalid'
                                }, self);
                            }
                        } else {
                            self.model.update({
                                request_status: s
                            }, self);
                        }

                        delete this._loading;
                        var _this = this;
                        $.each(this._callbacks, function(i, callback) {
                            callback.call(_this, address);
                        });
                        delete this._callbacks;
                    }, this)
                });
            }
        },


       //уже есть загруженные данные по карте
        isMapPointLoaded: function() {
          return this.model.get('auto_precision') &&  this.model.get('request_status') == 'success';
       }



    });


})(jQuery);
