(function($) {
    //кэш списков метро для города
    var metroListsCache = {},
        //кэш странций по заданым координатам
        metroLocationsCache = {},
        dataListeners = {};
    /**
     * Кэширующий загрузчик (такой же как в b-region-suggest).
     * Одновременно могут прийти несколько запросов на 1 урл.
     * В этом случае мы ждем делаем только один реальный запрос,
     * и после того как он завершится дергаем все колбэки
     * для этого урла.
     */
    function loadData (id, url, callback) {
        function notifyListeners (url) {
            $.each(dataListeners[url], function(i, callback) { callback(metroListsCache[url]) });
            dataListeners[url] = null;
        }

        if (dataListeners[url]) {
            dataListeners[url].push(callback);
        } else {
            dataListeners[url] = [callback];
            if (metroListsCache[url]) {
                notifyListeners(url);
            } else {
                window[id] = function(data) {
                    metroListsCache[url] = data;
                    notifyListeners(url);
                };

                var head = document.getElementsByTagName("head")[0],
                    script = document.createElement("script");
                script.src = url.replace(/callback=\?/, 'callback=' + id);
                head.appendChild(script);
            }
        }
    }

    BEM.DOM.decl({name:'b-vcard-form-metro', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                this.__base();
                var dataUrl = this.params.url,
                    requestid = dataUrl.replace(/^.*\//, '').replace(/\?.*$/, ''),
                    metro = this.elem('metro-hidden').val(),
                    self = this;

                this.model.initData({'metro': metro, disable_metro: metro === '0' }, this);
                loadData(requestid, dataUrl, function(loadedData) {
                    self.data = loadedData;
                    self.onMetroLoaded();
                });

            },

            disabled: function(modeName, newVal) {
                this.afterCurrentEvent(function() {
                    this.elem('select').prop('disabled', newVal == 'yes');
                    this.elem('check').prop('checked', newVal == 'yes' && this.model.get('disable_metro'));
                    if (newVal == 'yes') {
                        this.elem('metro-hidden').val(0);
                        this.elem('select').val(0);
                    }
                })
            }
        },

        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = 'b-vcard-form-map';
            this.parentRow = this.domElem.closest('.b_vcard_form__metro__tr');
            this.addressModel =  BEM.blocks['i-models-manager'].get(this._modelPath, 'b-vcard-form-address');
            this.vcardModel =  BEM.blocks['i-models-manager'].get(this._modelPath, 'b-vcard-form');
            this.data = {};
        },

        bindEvents: function() {
            var self = this;
            this.__base();
            this.vcardModel.onField('city', 'change', this.buildNewMetroList, this);
            this.model.on('finishEditing.map', this.selectLoadedMetro, this);
            this.model.on('finishEditing.placemark', this.findMetro, this);

            this.vcardModel.on('clear', this.clearMetro, this);


            this.model.onField('disable_metro', 'change', this.onMetroDisabled, this);
            this.model.onField('metro', 'change', function() {
                var metro = this.model.get('metro');
                self.elem('select').val(metro);
                self.elem('metro-hidden').val(metro);
            }, this);

            this.bindTo('select', 'change', function() {
                var metro = self.elem('select').val();
                self.model.set('metro', metro, self);
                self.elem('metro-hidden').val(metro);
                self.model.un('finishEditing.map', this.selectLoadedMetro, this);
                self.model.un('finishEditing.placemark', this.findMetro, this);
            });

            this.bindTo('check', 'click', function() {
                var checked = self.elem('check').prop('checked');
                this.model.set('disable_metro', checked, this);
            });


        },

        onMetroDisabledCallback: function(disabled) {
            this.setMod('disabled', disabled ? 'yes' : 'no');
            this.vcardModel[(disabled ? 'un' : 'on') + 'Field']('city', 'finishEditing', this.buildNewMetroList, this);
            this.model[disabled ? 'un' : 'on']('finishEditing.placemark', this.findMetro, this);
        },

        onMetroDisabled: function() {
            var disabled =  this.model.get('disable_metro'), self = this;
            if (disabled) {
                this.onMetroDisabledCallback(disabled);
            } else {
                //если метро уже найдено - заново не ищем
                if (this.model.get('metro')) {
                    this.selectLoadedMetro();
                    return this.onMetroDisabledCallback(disabled);
                }

                // если указан город и введен адрес, то можно искать станцию метро рядом
                this.vcardModel.get('city') && !this.addressModel.isModelEmpty('input') && this.findMetro({ }, function() {
                    self.onMetroDisabledCallback(disabled);
                });
            }
        },

        findMetroForCity: function() {
            var metroData;
            for (var i=0, h = this.data.length; i < h; i++) {
                if (this.data[i].city &&
                    this.vcardModel.get('city') &&
                    this.data[i].city.toLowerCase() ==  this.vcardModel.get('city').toLowerCase()) {
                    metroData = this.data[i];
                    break;
                }
            }
            return metroData;
        },

        setCityWithMetro: function() {
            this.parentRow.removeClass('g-hidden');
            if (!this.model.get('disable_metro')) {
                this.setMod('disabled', 'no');
                this.elem('metro-hidden').prop('disabled',false);
            }
        },

        setCityWithoutMetro: function() {
            this.parentRow.addClass('g-hidden');
            this.setMod('disabled', 'yes');
            this.elem('metro-hidden').prop('disabled', true);
        },

        buildNewMetroList: function() {
            this.elem('select').html('<option value="0">' + iget('не указана') + '</option>');
            if (!this.model.get('disable_metro')) {
                this.model.on('finishEditing.map', this.selectLoadedMetro, this)
                    .on('finishEditing.placemark', this.findMetro, this);
            }

            var metroData = this.findMetroForCity();

            if (metroData) {
                var metro = metroData.metro;
                for (var j=0, k = metro.length; j < k; j++) {
                    this.elem('select').append('<option value="' + metro[j].region_id + '">' + metro[j].name + '</option>');
                }
                this.iconMetro(metroData.city_id);
                this.setCityWithMetro();
                this.selectLoadedMetro();
            } else {
                this.setCityWithoutMetro();
            }

        },

        getAdressKey: function() {
            return (this.vcardModel.get('city') || '') +
                '_' + (this.model.get('manual_point').split(',')[0] || this.model.get('auto_point').split(',')[0] || '') +
                '_' + (this.model.get('manual_point').split(',')[1] || this.model.get('auto_point').split(',')[1] || '');
        },

        findMetro: function(e, callback) {
            var self = this, id;
            if (id = metroLocationsCache[this.getAdressKey()]) {
                self.model.set('metro', id);
                self.selectLoadedMetro();
                if (typeof callback == 'function') {
                    callback();
                }
                return;
            }

            var x = self.model.get('manual_point').split(',')[0] || self.model.get('auto_point').split(',')[0] || '',
                y = self.model.get('manual_point').split(',')[1] || self.model.get('auto_point').split(',')[1] || '',
                city = this.vcardModel.get('city') || '';

            if (city && !x && !y && this.findMetroForCity()) {
                if (typeof callback == 'function') {
                    callback();
                }
                return;
            }

            $.ajax({
                url: '/registered/main.pl',
                type: 'POST',
                dataType: 'json',
                data: {
                    cmd: 'ajaxSearchMetro',
                    city: city,
                    x: x,
                    y: y
                },
                success: function(data) {
                    if (data) {
                        metroLocationsCache[self.getAdressKey()] = data.region_id || '';
                        self.model.set('metro', data.region_id || '');
                        self.selectLoadedMetro();
                    }
                    if (typeof callback == 'function') {
                        callback();
                    }
                }
            });
        },

        selectLoadedMetro: function() {
            if (this.model.get('metro') === '0' && !this.model.get('disable_metro')
                || this.model.get('metro') !== '0' && this.model.get('disable_metro')) {
                this.model.set('disable_metro', this.model.get('metro') === '0')
            }

            if (this.model.get('disable_metro') != (this.elem('check').prop('checked'))) {
                this.elem('check').prop('checked', this.model.get('disable_metro'))
            }

            if (!this.model.get('disable_metro')) {
                var metro = this.model.get('metro');
                this.elem('select').val(metro);
                this.elem('metro-hidden').val(metro);
            } else {
                this.elem('select').val(0);
                this.elem('metro-hidden').val(0);
            }
        },

        iconMetro: function(city) {
            if (city == 2) {
                this.elem('icon').removeClass('b-vcard-form-metro__icon_kiev').addClass('b-vcard-form-metro__icon_piter');
            } else if (city == 143) {
                this.elem('icon').removeClass('b-vcard-form-metro__icon_piter').addClass('b-vcard-form-metro__icon_kiev');
            } else {
                this.elem('icon').removeClass('b-vcard-form-metro__icon_piter b-vcard-form-metro__icon_kiev');
            }
        },



        clearMetro: function() {
            this.setMod('disabled', 'yes');
            this.elem('metro-hidden').prop('disabled', true);
            this.parentRow.addClass('g-hidden');
        },

        onMetroLoaded: function() {
            if (this.elem('check').prop('checked')) {
                this.setMod('disabled', 'yes')
            }
            this.buildNewMetroList();
        }
    });


})(jQuery);
