(function($) {
    BEM.DOM.decl({name:'b-vcard-form-place', baseBlock: 'b-model-block'}, {
        initConsts: function() {
           this._modelPath = this.params.modelPath;
           this._modelName = 'b-vcard-form';
        },

        bindEvents: function() {
            this.__base();
            var self = this;

            this.bindTo('city-suggest', 'regionIdChanged', function() {
                self.model.update({
                    city: this.findBlockOn('city', 'b-form-input').elem('input').val(),
                    country: self.getElementValue('country')
                }, self).triggerField('city', 'finishEditing');
            });
            this.bindTo('country-suggest', 'regionIdChanged', function() {
                self.model.update({
                    city:  self.getElementValue('city'),
                    country: this.findBlockOn('country', 'b-form-input').elem('input').val()
                },  self).triggerField('country', 'finishEditing');
            });

            $.each(this.model.getFieldsNames('input'), $.proxy(function(i, name) {
               var elemName = this.model.getElemName(name), self = this;
               if (this.elem(elemName).length > 0 ) {
                   this.bindTo(elemName, 'blur', function() {  self.model.debounceTrigger('finishEditing'); });
                  this.bindTo(elemName, 'focus', function() { self.model.debounceTrigger('startEditing'); });

               }
           }, this));
        }
    });




})(jQuery);

