(function($) {

BEM.DOM.decl({name:'b-vcard-form-switcher', modName: 'type', modVal: 'banner'}, {
    onSetMod: {
        js: function() {
            this.model = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit');
            this.switcher = this.findBlockInside('b-form-switch');
            this.switcher.on('change', this.onSwitch, this);
            this.__base();
            //DIRECT-23668
            this.onVCardChange();
        }
    },

    onVCardChange: function() {
        this.elem('hidden').val(this.isVCardEmpty() ? 0 : 1);
        //DIRECT-23668
        this.elem('with-phone').val(+this.switcher.val() && !this.isVCardEmpty() ? '1' : '0');

        this.model.update({
            with_ci: this.switcher.position() == 'left' && !this.isVCardEmpty() ? 1 : 0
        });
    },

    onSwitch: function(e, data) {
        var ciHidden = data.state == 'right' ? 1 : 0;

        this.setHiddenValue(data.state == 'right' ? 0 : 1);

        ciHidden && direct.CampOptions.set('ci_hidden', 1);
        !ciHidden && direct.CampOptions.remove('ci_hidden');

        this.model.update({
            ci_hidden: ciHidden,
            with_ci: data.state == 'left' && !this.isVCardEmpty() ? 1 : 0
        }, this);

        // DIRECT-23538: Показываются предупреждения об изменении ЕКИ, хотя изменения не сохранялись.
        this.elem('hidden').val(ciHidden);
        this.elem('with-phone').val(+!ciHidden && +!this.isVCardEmpty());
    }
})

})(jQuery);
