(function($) {

BEM.DOM.decl({name:'b-vcard-form-switcher', modName: 'type', modVal: 'campaign'}, {
    onSetMod: {
        js: function() {
            this.campModel = BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-edit');
            this.__base();
            this.bindTo('hide', 'click', this.hideVCard);
            this.bindTo('show', 'click', this.showVCard);


            this.campModel.onField('with_ci', 'change', this.setVCard, this);
            this.vcardModel.on('error-set', this.showVCard, this);


        }


    },



    setVCard: function() {
        var hasVCard = this.campModel.get('with_ci');
        this.setHiddenValue(+hasVCard)
        this.elem('show-link-block').toggleClass('g-hidden', !hasVCard);
        this[hasVCard ? 'showVCard' : 'hideVCard']();
    },

    hideVCard: function() {
        this.setMod('hidden', 'yes');
        this.campModel.set('ci_hidden', 1)
    },

    showVCard: function() {
        this.setMod('hidden', 'no');
        this.campModel.set('ci_hidden', 0)
    }
})

})(jQuery);
