BEM.DOM.decl({name: 'b-vcard-form-switcher', modName: 'type', modVal: 'easy'}, {
    onSetMod: {
        js: function() {
            this.model = BEM.blocks['i-models-manager'].get(this.params.modelPath, 'b-banner-edit')
                .onField('ci_checked', 'change', this.onModelChanged.bind(this));

            this.model.initField('ci_checked', this.model.get('with_ci'), this);

            this.switcher = this.findBlockInside('b-form-checkbox');
            this.switcher.on('change', this.onCheckboxSwitched, this);

            this.__base();

        }
    },

    onModelChanged: function(e, data) {

        //if (data.source == this) return;
        if (!this.switcher) return;

        var checked = this.model.get('ci_checked');

        this.switcher.setMod('checked', checked ? 'yes' : 'no');
        this.updateControls();

        this.model.update({
            ci_hidden: !checked,
            with_ci: checked && !this.isVCardEmpty() ? 1 : 0
        }, this);
    },

    onCheckboxSwitched: function() {
        if (this.switcher.getMod('focused') != 'yes') return;

        this.updateControls();
        var checked = this.switcher.getMod('checked') == 'yes';
        
        this.model.update({
            ci_checked: +checked,
            ci_hidden: +(!checked),
            with_ci: +checked && !this.isVCardEmpty() ? 1 : 0
        }, this);
        checked || this.model.set('disableHref', 0, { source: this });
    },


    updateControls: function() {
        var checked = this.switcher.getMod('checked') == 'yes';
        this.setHiddenValue(+checked);
        this.elem('star').toggleClass('g-hidden', !checked);

    },



    onVCardChange: function() {
        var withCi = this.switcher.getMod('checked') == 'yes' && !this.isVCardEmpty() ? 1 : 0;
        this.elem('hidden').val(withCi);
        this.model.update({
            with_ci: withCi
        });
    }
});
