(function($, Lego) {
    var defaultValuesStr = '0#4#10#00#18#00',
        defaultWorktime = [0, 4, 10, '00', 18, '00'],
        weekDays = iget('пн вт ср чт пт сб вс').split(' ');

    BEM.blocks['b-model'].register('b-vcard-form-worktime', {
        fields: {
            'worktime': {type: 'string', input: 1, fromServer: 1, toServer: 1, 'default': '0#4#10#00#18#00'}
        }
    });

    BEM.DOM.decl({name:'b-vcard-form-worktime', baseBlock: 'b-model-block'}, {
        onSetMod: {
            js: function() {
                //внимание - порядок вызовов важен - не менять без необходимости
                this.initConsts();
                this.initModel();
                this.initData();
                this.values = [];
                this.rows = [];
                this.init();
                this.bindEvents();
            }
        },

        bindEvents: function() {
            this.model.onField('worktime', 'change', this.onExternalChange, this);
            this.__base();
        },

        onExternalChange: function(e, data) {
            if (data.source == this) {
                return;
            }
            this.init();
        },

        initConsts: function() {
           this._modelPath = this.params.modelPath;
           this._modelName = 'b-vcard-form-worktime';
        },

        //DIRECT-18196 - убрать когда Лена починит на сервере
        from0to24: function(val) {
            var newVal = this._getValuesFromString(val);
            for (var i = 0; i < newVal.length; i++) {
                if (newVal[i][4] == '00') { newVal[i][4] = 24};
            }
            this._setValues(newVal);
            newVal = this._valuesToString();
            return newVal;
        },

        //DIRECT-18196
        from24to0: function(val) {
            var newVal = this._getValuesFromString(val);
            for (var i = 0; i < newVal.length; i++) {
                if (newVal[i][4] == 24) { newVal[i][4] = '00'};
            }
            this.values = [].concat(newVal);
            newVal = this._valuesToString();
            return newVal;
        },

        getText: function() {
            var text = '', self = this;
            $.each(this.values, function(i, value) {
                text += text ? ', ' : '';
                if (self.values.length == 1 && value[0] == 0 && value[1] == 6) {
                    text += iget('Ежедневно') + ': '
                } else {
                    text += weekDays[value[0]] + '-' + weekDays[value[1]] + ': ';
                }
                if (value[2] == 0 && value[3] == 0 && value[4] == 24 && value[5] == 0) {
                    text += iget('круглосуточно')
                } else {
                    text += value[2] + ':'+ value[3] + ' - ' + value[4] + ':' + value[5]
                }
            })
            return text;
        },

        init: function() {
            var val = this.model.get('worktime');

            if (!val) {
                this._updateHidden(defaultValuesStr);
            } else {
                var newVal = this.from0to24(val);
                this._updateHidden(newVal);
            }




        },

        _updateHidden: function(val) {
            this.model.update({'worktime': this.from24to0(val)}, this);
            this.elem('worktime').val(this.from24to0(val));
        },


        _updateClonator: function(rowNum) {
            rowNum = rowNum == undefined ?  this.values.length - 1 : rowNum;
            var row = this.rows[rowNum],
               channel = this.channel(row.getChannelName());
            channel.trigger('update-clonator', {
                addHidden: rowNum != (this.values.length - 1),
                removeHidden:  this.values.length == 1
            });
        },



        _valuesToString: function() {
            return $.map(this.values, function(row) {
                return row.join('#')
            }).join(';');
        },

        _getValuesFromString: function(str) {
            str = str || defaultValuesStr;
            if (str) {
                return $.map(str.split(';'), function(row) {
                    return [row.split('#')];
                });
            }
        },

        _setValues: function(values) {

            this.values = [].concat(values);
            if (values.length == this.rows.length) {
                for (var i= 0, l = values.length; i < l; i++) {
                    this._setRowValues(this.rows[i], values[i])
                };
                this._updateClonator();
            } else {
                this._render(values);
            }

        },

        _setRowValues: function(row, values) {
            row.setTime({
                'day-from': values[0],
                'day-to': values[1],
                'hour-from': values[2],
                'min-from': values[3],
                'hour-to': values[4],
                'min-to': values[5]
            });
        },

        _render: function(values) {
            this.rows = [];
            var content = '';
            for (var i = 0; i < values.length; i++) {
                content += this._renderRow(values[i], i);
            };
            this.__self.update(this.elem('content'), content);
            this.rows = this.findBlocksInside('b-worktime');
            this._initChannels();

        },

        _addRow: function(values, num) {
            var row = $(this._renderRow(values, num));
            this.elem('content').append(row);
            this.__self.init(row);
            this.rows = this.findBlocksInside('b-worktime');
            this._initRowChannel(this.rows[num], num);
        },

        toggleAllDayLink: function() {
            this.rows[0].toggleAllDayLink(true)
        },

        _initChannels: function() {
            $.each(this.rows, $.proxy(function(i, row){
                this._initRowChannel(row, i)
            }, this))
        },

        _setAllWeek: function() {
            this.values = [[0, 6, this.values[0][2], this.values[0][3], this.values[0][4] == '00' ? 24 : this.values[0][4], this.values[0][5]]];
            this._render(this.values);
            this._updateHiddenFromValues();
        },

        _initRowChannel: function(row, i) {
            var channel = this.channel(row.getChannelName());
            channel.on('all-week', this._setAllWeek, this);
            channel.on('change-day', this._decorator(this._onDayChange, this, i));
            channel.on('change-time', this._decorator(this._onTimeChange, this, i));
            channel.on('add', $.proxy(this._onAddClick, this));
            channel.on('remove', this._decorator(this._onRemoveClick, this, i));
        },

        _reinitChannels: function() {
            $.each(this.rows, $.proxy(function(i, row){
                this._unbindRowChannel(row)
                this._initRowChannel(row, i)
            }, this))
        },

        _unbindRowChannel: function(row) {
            var channel = this.channel(row.getChannelName());
            channel.un('change-day');
            channel.un('change-time');
            channel.un('add');
            channel.un('remove');
        },

        _getDays: function() {
            var hasDays = [0, 0, 0, 0, 0, 0, 0];
            for (var i = 0; i < this.values.length;i++) {
                for (var day = this.values[i][0]; day <= this.values[i][1]; day++) {
                    hasDays[day] = 1;
                }
            }
            return hasDays;
        },



        _getNewRowWeekDays: function() {
            var hasDays = this._getDays(),
                firstDay = 0,
                lastDay = 0,
                prevDay = 0;

            prevDay = -100;
            for (var i = 0; i < 7; i++) {
                if (!hasDays[i]) {
                    if (prevDay == i - 1) {
                        lastDay = i;
                    } else {
                        firstDay = i;
                    }
                    prevDay = i;
                }
            }
            if (firstDay > lastDay) { lastDay = firstDay; }
            return [firstDay, lastDay];
        },

        _onAddClick: function(e) {
            this.values.push(defaultWorktime);
            this._addRow(defaultWorktime, this.values.length - 1);
            this._updateHiddenFromValues();
            //прячем "+" рядом с предыдущей строкой если он там был
            this._updateClonator(this.values.length - 2);
            this._updateClonator();
            this.toggleAllDayLink();
            return false;
        },

        _onRemoveClick: function(e, data, self, rowNum) {
            //уничтожаем канал
            self.channel(self.rows[rowNum].getChannelName(), true);
            //удаляем ноду
            self.__self.destruct(self.rows[rowNum].domElem);

            var tmp_rows = [], tmp_values = [];
            for (var i=0, l = self.values.length; i < l; i++) {
                if (rowNum != i) {
                    tmp_rows.push(self.rows[i]);
                    tmp_values.push(self.values[i]);
                }
            };

            self.rows = tmp_rows;
            self.values = tmp_values;

            self._reinitChannels();
            self._updateHiddenFromValues();
            self._updateClonator();
            self.toggleAllDayLink();

        },

        _decorator: function(f, variables) {
            var args = Array.prototype.slice.call(arguments, 1);
            return function () {
                var p = arguments;
                Array.prototype.push.apply(p, args);
                f.apply(this, p);
            }

        },

        _updateHiddenFromValues: function() {
            this._updateHidden(this._valuesToString());
            return this;
        },

        _onTimeChange: function(e, time, self, rowNum) {
            self.values[rowNum][2] = time[0];
            self.values[rowNum][4] = time[2];
            self.values[rowNum][3] = time[1];
            self.values[rowNum][5] = time[3];
            self._updateHiddenFromValues();
        },

        _onDayChange: function(e, days, self, rowNum) {
            if (self.values[rowNum][1] - self.values[rowNum][0] > days[1] - days[0]) {
                self._updateClonator()
            }
            self.values[rowNum][0] = days[0];
            self.values[rowNum][1] = days[1];
            self._updateHiddenFromValues();

        },

        _renderRow: function(values, num) {
            return BEM.HTML.build({
                block: 'b-worktime',
                'has-day': 'yes',
                'all-day': 'yes',
                 mix: [{block: 'b-vcard-form-worktime', elem: 'time-row'}],
                'day-from': values[0],
                'day-to': values[1],
                'hour-from': values[2],
                'min-from': values[3],
                'hour-to': values[4],
                'min-to': values[5],
                //ccылка ежедневно - только у первой строки
                'has-all-week': num == 0,
                'has-add': num == (this.values.length - 1),
                'has-remove': this.values.length > 1
            });
        }


    });






})(jQuery, window.Lego);
