include("../../block/b-vcard-form-worktime/b-vcard-form-worktime.js");
include("../../block/b-vcard-form-address/b-vcard-form-address.js");
include("../../block/b-vcard-form-map/b-vcard-form-map.js");
include("../../block/b-vcard-form-place/b-vcard-form-place.js");
include("../../block/b-vcard-form-metro/b-vcard-form-metro.js");
include("../../block/b-ogrn-input/b-ogrn-input.js");
include("../../block/b-vcard-form-copy/b-vcard-form-copy.js");

(function($) {
    BEM.blocks['b-model'].register('b-vcard-form', {
        fields: {
            'country': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'city': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'country_code': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'city_code': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'phone': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'ext': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'name': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'contactperson': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'contact_email': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'im_login': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'im_client': {type: 'string', fromServer: 1, toServer: 1, input: 1},
            'extra_message': {type: 'string', fromServer: 1, toServer: 1, input: 1}

        },

        childModels: {
            'b-vcard-form-worktime': {},
            'b-vcard-form-address': {},
            'b-vcard-form-map': {},
            'b-ogrn-input': {}
        },

        validateRules: {
            'country': {
                list: [ {name: 'required', id: 'required', text: iget('страна')}],
                condition: function() { return !this.isModelEmpty('input', 1, ['im_client', 'worktime']) }
            },
            'city': {
                list: [ {name: 'required', id: 'required', text: iget('город')}], condition: function() { return !this.isModelEmpty('input', 1, ['im_client', 'worktime']) }
            },
            'country_code': {
                list: [ {name: 'required', id: 'required', text: iget('код страны')}], condition: function() { return !this.isModelEmpty('input', 1, ['im_client', 'worktime']) }
            },
            'city_code': {
                list: [ {name: 'required', id: 'required', text: iget('код города')}] ,
                condition: function() { return !this.isModelEmpty('input', 1, ['im_client', 'worktime']) }
            },
            'phone': {
                list: [ {name: 'required', id: 'required', text: iget('телефон')}],
                condition: function() { return !this.isModelEmpty('input', 1, ['im_client', 'worktime']) }
            },
            'name': {
                list: [ {name: 'required', id: 'required', text: iget('название компании/ФИО')}],
                condition: function() { return !this.isModelEmpty('input', 1, ['im_client', 'worktime']) }
            }
        },

        //общий текст ошибки для модели
        errorText: iget('Ошибки в полях формы "Адрес и телефон"')
    });

    BEM.DOM.decl({name:'b-vcard-form', baseBlock: 'b-model-block'}, {
        onSetMod : {
            js: function() {
                var _this = this;
                _this.params.modelPath = this.params.bannerModelPath || this.params.modelPath;

                this.linkedBlocks = {
                    'address':  this.findBlockInside('b-vcard-form-address'),
                    'place':  this.findBlockInside('b-vcard-form-place'),
                    'map': this.findBlockInside('b-vcard-form-map'),
                    'worktime':  this.findBlockInside('b-vcard-form-worktime'),
                    'ogrn':  this.findBlockInside('b-ogrn-input')
                };

                this.__base();
                _this.bannerModel = this.params.bannerModelPath && BEM.blocks['i-models-manager'].get(this.params.bannerModelPath, 'b-banner-edit');
                if (!_this.bannerModel) {
                    _this.campaignModel =  BEM.blocks['i-models-manager'].get('campaign', 'b-campaign-edit');
                }
                _this.bannerModel && _this.bannerModel.onField('ci_hidden', 'change', function() {
                    _this.setMod('hidden',_this.bannerModel.get('ci_hidden') ? 'yes' : 'no')

                });

                _this.campaignModel && _this.campaignModel.onField('ci_hidden', 'change', function() {
                    _this.setMod('hidden', _this.campaignModel.get('ci_hidden') ? 'yes' : 'no')
                });


                _this.extraMessage = this.findBlockOn('extra-message', 'b-form-input')
                    .on('change', this.updateExtraCounter, this);

                _this.updateExtraCounter();

                // DIRECT-12006
                BEM.blocks['b-form-input'].on(this.domElem, 'blur', function() {
                    this.val($.trim(this.val()));
                });

            },

            'hidden': function(modName, modVal) {
                var nextSibling = this.domElem[0].nextSibling;
                // MSIE fails to hide tbody, so we remove and put it back, forcing IE to redraw
                $.browser.msie && nextSibling.parentNode.removeChild(this.domElem[0]);
                $.browser.msie && nextSibling.parentNode.insertBefore(this.domElem[0], nextSibling);

                $(window).trigger('js-page-resize');
            }

        },



        onErrorSet: function(e, data) {
            var errors = {name: [], place: [], phone: []}, _this = this;

            for (var i = 0; i < data.fields.length; i++) {
                var fieldId = data.fields[i];

                if ($.inArray(fieldId, ['country', 'city']) != -1) { errors.place.push(fieldId); continue;}
                if ($.inArray(fieldId, ['country_code', 'city_code', 'phone']) != -1) { errors.phone.push(fieldId); continue;}
                if ($.inArray(fieldId, ['name']) != -1) {  errors.name.push(fieldId); continue;}
            }



            $.each(['place', 'phone', 'name'], function(i, name) {
                if (errors[name].length > 0) {
                    _this.elem(name + '-error').html(iget('Заполнены не все требуемые поля: ') + $.map(errors[name], function(id) {
                        return  _this.model.getErrorsMessagesForField(id).join('<br/>');
                    }).join(', '));
                }
            });


        },

        onErrorClear: function(e, data) {
            var placeErrors = [], phoneErrors = [], nameErrors = [];
            for (var i = 0; i < data.fields.length; i++) {
                var fieldId = data.fields[i];
                if ($.inArray(fieldId, ['country', 'city']) != -1) { placeErrors.push(fieldId); continue;}
                if ($.inArray(fieldId, ['country_code', 'city_code', 'phone']) != -1) { phoneErrors.push(fieldId); continue;}
                if ($.inArray(fieldId, ['name']) != -1) { nameErrors.push(fieldId); continue;}

            }
            if (placeErrors.length > 0) {
                this.elem('place-error').html('')
            }
            if (phoneErrors.length > 0) {
                this.elem('phone-error').html('')
            }
            if (nameErrors.length > 0) {
                this.elem('name-error').html('')
            }
        },

        updateExtraCounter: function() {
            var limit = 200 - this.extraMessage.val().length;
            this.elem('extra-counter').html(limit);
            this.setMod('overflow', limit < 0 ? 'yes' : 'no')
        },


        validate: function() {
            if (this.model.isModelEmpty('input')) { return true; }
            var validate = this.model.validateModel();

            $.each(this.linkedBlocks, function(name, block) {
                if (block) {
                    validate = validate && block.validate();
                }
            });
            return validate;
        },

        initConsts: function() {
            this._modelPath = this.params.modelPath;
            this._modelName = 'b-vcard-form';
        },

        getHiddens: function() {
            var hiddens = this.model.memento('toServer');
            $.each(this.linkedBlocks, function(name, block) {
                if (block) {
                    $.extend(hiddens, block.getHiddens())
                }
            });
            return hiddens;
        },

        getText: function() {
            if (this.model.isModelEmpty('input')) { return iget('не выбран'); }
            var text = this.model.get('country') + ', ' + this.model.get('city') + '. ';
            text += iget('Телефон: ') + this.model.get('country_code') + ' (' + this.model.get('city_code') + ') '
                + this.model.get('phone');
            text += this.model.get('ext') ? iget('доб. ') + this.model.get('ext') + '. ' : '. ';
            text += iget('Название: ') + this.model.get('name') + '. ';
            if (this.model.get('contactperson')) {
                text += iget('Контактное лицо: ') + this.model.get('contactperson') + '. '
            }
            text += iget('Время работы: ') + this.linkedBlocks.worktime.getText() + '. ';
            var address = this.linkedBlocks.address.getText();
            if (address) {
                text += iget('Адрес: ') + address + '. ';
            }
            if (this.model.get('email')) {
                text += iget('Эл.почта: ') + this.model.get('email') + '. '
            }
            return text;
        }
    });


})(jQuery);

