BEM.DOM.decl('b-wallet-day-budget-popup', {
    onSetMod: {
        js: function() {
            this.__self.instance = this;

            //кэшируем, чтобы быд доступен после открытия попапа
            this.elem('show-mode');
            this.elem('stop-radio');
            this.elem('errors');
            this.elem('content') ;

            this.submit = this.findBlockOn(this.elem('submit'), 'b-form-button')
                .on('click', this.onSubmit, this);
            this.cancel = this.findBlockOn(this.elem('cancel'), 'b-form-button')
                .on('click', this.onCancel, this);
            this.input = this.findBlockOn(this.elem('input'), 'b-form-input')
                .on('blur', this.onInputBlur, this);
            this.bindTo('stop-radio', 'click', this.updateStoppedMod, this);

            this.popup = this.findBlockInside('b-popupa');
        }

    },

    onElemSetMod: {
        'content': {
            'stopped': function(elemName, modeName, modVal) {
                this.input.setMod('disabled', modVal);
                this.elem('show-mode').attr('disabled', modVal == 'yes');
            }
        }
    },

    updateStoppedMod: function() {
        this.setMod(this.elem('content'), 'stopped', +(this.elem('stop-radio').filter(':checked').val()) ? 'yes' : 'no');
    },

    setCampaign: function(cid) {
        this.model = BEM.MODEL.get('campaign:' + cid, 'b-campaign-view');
        this.updatePopup();
    },

    updatePopup: function() {
        var dayBudget = this.model.get('day_budget');
        this.input.val(+dayBudget ? dayBudget : '');
        this.elem('stop-radio').filter('[value=' + (+(dayBudget == 0)) + ']').attr('checked', 'checked');
        this.updateStoppedMod();
        this.elem('show-mode').val(this.model.get('day_budget_show_mode'));
        this.elem('errors').text('');
    },

    onInputBlur: function() {
        var value = this.input.val();

        this.elem('errors').text('');
        this.input.val(common.number.format(value, {precision: 2, exponent_delimiter: '', fail: value}));
    },

    getRequest: function() {
        var ajaxUrl = '/registered/main.pl';

        if (this._request) return this._request;

        return (this._request = BEM.create("i-request_type_ajax", {
            url: ajaxUrl,
            cache: false,
            type: 'POST',
            dataType: 'json',
            onError: function () {
                //todo - какая ошибка?
            }
        }));
    },

    getDayBudgetData: function() {
        var data = {};

        data.set = !(+this.elem('stop-radio').filter(':checked').val());
        if (data.set) {
            data.sum = common.number.format(this.input.val(), {precision: 2, exponent_delimiter: ''});
            data.show_mode = this.elem('show-mode').val()
        }
        return data;
    },

    onSubmit: function() {
        var data = this.getDayBudgetData();

        if (data.set && (direct.utils.isEmpty(data.sum) || !common.number.isDecimal(data.sum))) {
            this.elem('errors').text(iget('Неправильный формат'));
            return;
        }
        this.getRequest().get({
            cmd: 'ajaxSaveDayBudget',
            cid: this.model.get('cid'),
            ulogin: this.params.ulogin,
            json_day_budget: JSON.stringify(data),
            csrf_token: window.csrf_token
        }, function(result) {
            if (result.error) {
                this.elem('errors').text(result.error);
            } else {
                this.model.update(this.filterToClient(data));
                this.hide();
            }
        }, {
            callbackCtx: this
        })
    },

    onCancel: function() {
        this.hide();
    },

    filterToClient: function(data) {
        return res = {
            'day_budget': data.sum,
            'day_budget_show_mode': data.show_mode
        };
    },

    show: function(cid, owner) {
        this.popup.show(owner);
        this.setCampaign(cid);
    },

    hide: function() {
        this.popup.hide();
    }
}, {
    live: false,
    getInstance: function() {
        return this.instance;
    }
});
