(function($){



    BEM.DOM.decl('b-wallet-day-budget', {
        onSetMod: {
            'js': function(){
                this.btn = this.findBlockInside('b-form-button')
                    .on('click', this.openPopup, this);

                this.model = BEM.MODEL.get('campaign:' + this.params.cid, 'b-campaign-view')
                    .onField('day_budget', 'change', this.onBudgetChanged, this);
            }
        },


        onBudgetChanged: function() {
            var value = this.model.get('day_budget');
            this.setMod('warning', +value < this.params.recomendedBudget ? 'yes' : 'no');
            this.btn.elem('text').text(+value ? value : iget('не задан'));
        },

        openPopup: function() {
            BEM.blocks['b-wallet-day-budget-popup'].getInstance().show(this.params.cid, this.btn.domElem)
        },

        onRadioChange: function(e) {
            this.setMod(this.elem('body'), 'restraction', e.data.domElem.val() == 1 ? 'no' : 'yes')
        }

    }, {
        live: function(){
            this.liveInitOnEvent('sum', 'click', function() {
                this.openPopup();
            })
        }
    });

})(jQuery);

BEM.DOM.decl('b-wallet-day-budget-popup', {
    onSetMod: {
        js: function() {
            
        }
    }
}, {
    live: function() {

    }
});

