(function($){

BEM.DOM.decl('b-wallet-pay', {
    onSetMod: {
        'js': function(){
            this.elem('content');
            this.elem('errors');

            this.popupa = this.findBlockInside('b-popupa');
            this.input = this.findBlockOn('input', 'b-form-input')
                .on('blur', this.onInputBlur, this)
                .on('change', this.onInputChange, this);

            this.submit = this.findBlockOn('submit', 'b-form-button')
                .on('click', this.onSubmit, this);
            this.cancel = this.findBlockOn('cancel', 'b-form-button')
                .on('click', function() { this.popupa.hide() }, this);

            this.model = BEM.MODEL.get('user', 'm-client-wallet')
                .update({ 'currency': this.params.currency, sum: this.input.val() }).fixData();
            this
                .onInputChange()
                .onInputBlur();
        }
    },

    updateDisabled: function() {
        this.submit.setMod('disabled', this.model.get('sum') !== undefined && this.model.get('sum') !== '' ? '' : 'yes');

        return this;
    },

    onInputChange: function() {
        this.model.set('sum', this.input.val(), this);

        this.updateDisabled();
        this.setMod(this.elem('content'), 'errors', 'no');

        return this;
    },

    onInputBlur: function() {
        this.input.val(isNaN(this.model.get('sum')) || this.model.get('sum') === '' ? this.model.raw('sum') : this.model.view('sum'));

        return this;
    },

    onSubmit: function() {
        this.model.validateField('sum');

        var hasErrors = this.model.hasErrors();
        if (hasErrors) {
            this.elem('errors').text(this.model.getErrorsMessagesForField('sum').join(', '));
            this.setMod(this.elem('content'), 'errors', 'yes');
            return;
        }
        this.elem('sum').val(this.model.get('sum'));
        this.elem('form').submit();
    }
});

})(jQuery);
