BEM.DOM.decl({ name: 'b-wallet-warnings', baseBlock: 'b-outboard-controls' }, {
    onSetMod: {
        js: function() {
            this.spin = this.findBlockOn('popup-spin', 'b-spin');
            //кэшируем пока не открылся попап
            this.elem('popup-spin');
            this.errors = this.elem('common-errors');
            this.__base();

            this._request = BEM.create("i-request_type_ajax", {
                type: 'post',
                url: '/registered/main.pl',
                dataType: 'json',
                callbackCtx: this
            });

            this.getInnerBlock().initData();

        },

        disabled: function(modName, modVal) {
            this.setMod(this.elem('popup-spin'), 'visible', modVal);
            this.acceptButton.setMod('disabled', modVal);
        }
    },


    prepare: function() {
        this.errors.text('');

        this.__base();
    },

    accept: function() {
        var innerBlockModel = this.getInnerBlock().model;

        this.callInnerMethod('provideData');
        if (innerBlockModel.validate()) {
            this.setMod('disabled', 'yes');

            var data = {
                'cmd': 'ajaxSaveWalletSettings',
                'cid': this.params.cid
            };

            $.extend(data, innerBlockModel.memento(true));
            this.params.ulogin && (data.ulogin = this.params.ulogin);

            this._request.get(data, function(response) {
                if (response.error) {
                    this.errors.text(response.error);
                    return;
                } else {
                    innerBlockModel.fixData();
                    this.popup.hide();
                    this.trigger('accept');
                }
                this.setMod('disabled', 'no');
            });
        }

    }
}, {

});
